package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocQryChngOrderObjListServiceImpl
 * 说明:变更单对象列表查询
 * 时间:2022/3/14 21:40
 * 作者:罗有
 */
@HTServiceImpl
public class UocQryChngOrderObjListServiceImpl implements UocQryChngOrderObjListService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Override
    public UocQryChngOrderObjListRspBo getChngOrderObjList(UocQryChngOrderObjListReqBo reqBo) {
        val(reqBo);
        UocQryChngOrderObjListRspBo rspBo = UocRu.success(UocQryChngOrderObjListRspBo.class);
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocChngOrderObj> chngOrderObjList = iUocChngOrderModel.getChngOrderObjList(uocChngOrderObjQryBo);
        if (CollectionUtils.isNotEmpty(chngOrderObjList)){
            rspBo.setChngOrderObjBoList(UocRu.jsl(chngOrderObjList,UocChngOrderObjBo.class));
        }
        return rspBo;
    }

    private void val(UocQryChngOrderObjListReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
    }
}
