package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderStakeholderQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderStakeholderQryServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-销售单三方信息查询实现〉
 * @author : yuhao
 * @date : 2022/7/21 15:56
 */
@HTServiceImpl
public class UocSaleOrderStakeholderQryServiceImpl implements UocSaleOrderStakeholderQryService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    /**
     * 销售单三方信息查询
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocSaleOrderStakeholderQryServiceRspBo qrySaleOrderStakeholder(UocSaleOrderStakeholderQryServiceReqBo reqBo) {
        UocSaleOrderStakeholderQryServiceRspBo rspBo = new UocSaleOrderStakeholderQryServiceRspBo();
        UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
        BeanUtils.copyProperties(reqBo,uocSaleStakeholderQryBo);
        UocSaleStakeholder saleOrderStakeholder = this.iUocSaleOrderModel.getSaleOrderStakeholder(uocSaleStakeholderQryBo);
        if(null != saleOrderStakeholder){
            BeanUtils.copyProperties(saleOrderStakeholder,rspBo);
        }
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }
}
