package com.tydic.dyc.oc.service.insporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.service.insporder.bo.UocGetInspOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.insporder.bo.UocGetInspOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetInspOrderDetailBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 描述: 〈领域服务-验收单详情查询〉
 * @author : yincs
 * @date : 2023/2/2 11:37
 */
@Slf4j
@HTServiceImpl
public class UocGetInspOrderDetailServiceImpl implements UocGetInspOrderDetailService{
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Override
    public UocGetInspOrderDetailServiceRspBo getInspOrderDetail(UocGetInspOrderDetailServiceReqBo reqBo) {
        //参数校验
        validateParam(reqBo);
        //查询验收单（按道理只有一条）
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setInspOrderId(reqBo.getInspOrderId());
        log.info("验收单表入参查询",uocInspOrderQryBo);
        List<UocInspOrderDo> inspOrderList = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        log.info("验收单表出参查询",uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(inspOrderList)&&1==inspOrderList.size()) {
            UocInspOrderDo uocInspOrderDo = inspOrderList.get(0);
            //查询验收单明细
            UocGetInspOrderDetailServiceRspBo inspOrderInfoBo = UocRu.js(uocInspOrderDo, UocGetInspOrderDetailServiceRspBo.class);

            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setInspOrderId(reqBo.getInspOrderId());
            uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
            log.info("验收单详情表入参查询",uocInspOrderItemQryBo);
            UocInspOrderDo listInspOrderItem = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
            log.info("验收单详情表出参查询",listInspOrderItem);
            if (null != listInspOrderItem && ObjectUtil.isNotEmpty(listInspOrderItem.getUocInspOrderItemList())) {
                inspOrderInfoBo.setInspOrderItemInfo(UocRu.jsl(listInspOrderItem.getUocInspOrderItemList(), UocGetInspOrderDetailBo.class));
            }
            inspOrderInfoBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
            inspOrderInfoBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
            log.info("验收单详情接口出参查询",inspOrderInfoBo);
            return inspOrderInfoBo;
        }
        else {
            UocGetInspOrderDetailServiceRspBo rspBo = new UocGetInspOrderDetailServiceRspBo();
            rspBo.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo.setRespDesc(UocRspConstants.RSP_DESC_FAIL);
            return rspBo;
        }


    }
    /**
     * 参数校验
     * @param reqBo
     */
    private void validateParam(UocGetInspOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
        if (reqBo.getInspOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
    }
}
