package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfAuditQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfAudit;
import com.tydic.dyc.oc.service.order.bo.UocAddExceptionAuditConfReqBo;
import com.tydic.dyc.oc.service.order.bo.UocAddExceptionAuditConfRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题:UocAddExceptionAuditConfServiceImpl
 * 说明:审批配置添加例外
 * 时间:2022-05-20 10:15:57
 * 作者:luoyou
 */

@HTServiceImpl
public class UocAddExceptionAuditConfServiceImpl implements UocAddExceptionAuditConfService {
	public static final Long ZORE = 0L;
	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Override
	public UocAddExceptionAuditConfRspBo addExceptionAuditConf(UocAddExceptionAuditConfReqBo reqBo) {
		val(reqBo);
		UocConfAuditQryBo uocConfAuditQryBo = new UocConfAuditQryBo();
		uocConfAuditQryBo.setOrgId(reqBo.getOrgIdWeb());
		UocConfAudit uocConfAudit = iUocOrderModel.getAudit(uocConfAuditQryBo);
		if ( null != uocConfAudit ) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_AUDIT_CONF_ERROR, StrUtil.format("{} 已经配置审批", reqBo.getOrgNameWeb()));
		}
		iUocOrderModel.addExceptionAuditConf(convertDo(reqBo));
		return UocRu.success(UocAddExceptionAuditConfRspBo.class);
	}

	private UocConfAudit convertDo(UocAddExceptionAuditConfReqBo reqBo) {
		UocConfAudit uocConfAudit = UocRu.js(reqBo, UocConfAudit.class);
		uocConfAudit.setId(IdUtil.nextId());
		uocConfAudit.setOrgId(reqBo.getOrgIdWeb());
		uocConfAudit.setOrgPath(reqBo.getOrgPathWeb());
		uocConfAudit.setOrgName(reqBo.getOrgNameWeb());
		uocConfAudit.setOrgType(reqBo.getOrgTypeWeb());
		uocConfAudit.setOperatorId(reqBo.getUserId().toString());
		uocConfAudit.setOperatorName(reqBo.getUsername());
		uocConfAudit.setOperatorTime(new Date());
		uocConfAudit.setSysAttr(UocConstant.SYS_ATTR.CUSTOMIZE);
		return uocConfAudit;
	}

	private void val(UocAddExceptionAuditConfReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (StringUtils.isBlank(reqBo.getConfCode())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配置编码不能为空");
		}
		if (StringUtils.isBlank(reqBo.getConfName())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配置名称不能为空");
		}
		if (StringUtils.isBlank(reqBo.getOrgNameWeb())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参机构名称不能为空");
		}
		if (null == reqBo.getOrgIdWeb()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参机构ID不能为空");
		}
		if (!ZORE.equals(reqBo.getOrgIdWeb())) {
			if (StringUtils.isBlank(reqBo.getOrgTypeWeb())) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参例外机构类型不能为空");
			}
			if (StringUtils.isBlank(reqBo.getOrgTypeName())) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参例外机构类型翻译不能为空");
			}
		}
		if (null == reqBo.getAuditFlag()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单是否审批不能为空");
		}
		if (UocConstant.CONF_AUDIT_FLAG.YES.equals(reqBo.getAuditFlag()) && null == reqBo.getAuditType()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参需要审批时审批方式不能为空");
		}
	}
}
