package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.service.saleorder.bo.UocBackSapOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description sap订单信息回调接口
 * @author Luokan
 * @date 2024/07/05
 **/
@HTServiceImpl
public class UocDealBackSapOrderServiceImpl implements UocDealBackSapOrderService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocDealBackSapOrderRspBO dealBackSapOrder(UocDealBackSapOrderReqBO reqBO) {
        UocDealBackSapOrderRspBO rspBO = UocRu.success(UocDealBackSapOrderRspBO.class);
        //推送类型：1 sap订单创建推送 2 sap订单取消推送 3 sap订单创建回调推送
        if (UocConstant.SapPushType.TYPE_1.equals(reqBO.getPushType())) {
            this.doTypeOne(reqBO);
        }else if (UocConstant.SapPushType.TYPE_2.equals(reqBO.getPushType())) {
            this.doTypeTwo(reqBO);
        }else if (UocConstant.SapPushType.TYPE_3.equals(reqBO.getPushType())) {
            this.doTypeSth(reqBO, rspBO);
        }
        return rspBO;
    }

    private void doTypeSth(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        String failValue = null;
        for (UocBackSapOrderBO bo : reqBO.getRows()) {
            if (null != bo.getVAULE() && !"".equals(bo.getVAULE())) {
                failValue = bo.getVAULE();
            }
        }
        Integer status = UocConstant.SapSendInfoStatus.STATUS_4;
        rspBO.setFlowFlag(true);
        if (null != failValue) {
            status = UocConstant.SapSendInfoStatus.STATUS_3;
            rspBO.setFlowFlag(false);
        }
        //查询销售单，查询销售明细
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderNo(reqBO.getRows().get(0).getZDDH());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        //判断当前销售单状态是正确的
        //todo
        if (UocConstant.SapSendInfoStatus.STATUS_4.equals(status)) {
            //查询任务表，找到最新的一条 判断当前状态，是否为未办理
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(result.getOrderId());
            qryInst.setObjId(result.getSaleOrderId());
            qryInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
            rspBO.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            //同步sap订单编号和sap订单明细编号
            Map<Long, UocBackSapOrderBO> saleOrderItemMap = reqBO.getRows().stream().collect(Collectors.toMap(bo -> Long.valueOf(bo.getZDDI()), Function.identity()));
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemListByItemIds(new ArrayList<>(saleOrderItemMap.keySet()));
            for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                UocBackSapOrderBO sapItem = saleOrderItemMap.get(saleOrderItem.getSaleOrderItemId());
                UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
                updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                updateSaleOrderItem.setSapOrderNo(sapItem.getEBELN());
                updateSaleOrderItem.setSapOrderItemNo(sapItem.getEBELP());
                this.iUocSaleOrderModel.modifyItemPlan(updateSaleOrderItem);
            }
        }
        //查询并更新推送记录表
        UocSapOrderSendInfo qryUocSapOrderSendInfo = new UocSapOrderSendInfo();
        qryUocSapOrderSendInfo.setOrderId(result.getOrderId());
        qryUocSapOrderSendInfo.setSaleOrderId(result.getSaleOrderId());
        qryUocSapOrderSendInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_1);
        qryUocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_3);
        List<UocSapOrderSendInfo> sapSendInfoList = this.iUocSaleOrderModel.getSapSendInfoList(qryUocSapOrderSendInfo);
        UocSapOrderSendInfo updateUocSapOrderSendInfo = new UocSapOrderSendInfo();
        updateUocSapOrderSendInfo.setSendInfoId(sapSendInfoList.get(0).getSendInfoId());
        updateUocSapOrderSendInfo.setOrderId(sapSendInfoList.get(0).getOrderId());
        updateUocSapOrderSendInfo.setSaleOrderId(sapSendInfoList.get(0).getSaleOrderId());
        updateUocSapOrderSendInfo.setStatus(status);
        updateUocSapOrderSendInfo.setSapRspParam(JSON.toJSONString(reqBO.getRows()));
        updateUocSapOrderSendInfo.setReason(failValue);
        updateUocSapOrderSendInfo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateSapSendInfo(updateUocSapOrderSendInfo);
    }

    private void doTypeTwo(UocDealBackSapOrderReqBO reqBO) {
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_2);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(new Date());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }

    private void doTypeOne(UocDealBackSapOrderReqBO reqBO) {
        //先更新之前的状态为废弃
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(new Date());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }
}
