package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocEsToCancelOrderRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryEsToCancelOrderBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 领域服务-电商待取消订单列表查询
 * @author yinletian
 * @date 2022/10/24
 */
@HTServiceImpl
public class UocQryEsToCancelOrderListServiceImpl implements UocQryEsToCancelOrderListService{


    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocEsToCancelOrderRspBO dealEsToCancelOrder() {

        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        //订单来源
        uocSaleOrderDo.setOrderSource(UocConstant.SkuSource.ELC);
        //预订单取消：E0007
        uocSaleOrderDo.setProcState("E0007");
        //完结标志
        uocSaleOrderDo.setFinishFlag(0);
        //单据类型2：销售单
        uocSaleOrderDo.setSaleOrderType(2);
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.cancelEsOrderList(uocSaleOrderDo);

        UocEsToCancelOrderRspBO rspBO = new UocEsToCancelOrderRspBO();

        if(!ObjectUtil.isEmpty(uocSaleOrderDos)) {
            rspBO.setUocQryEsToCancelOrderBOs(uocSaleOrderDos.stream().map(obj -> {
                UocQryEsToCancelOrderBO cancelOrderBO = new UocQryEsToCancelOrderBO();
                //订单id
                cancelOrderBO.setOrderId(obj.getOrderId());
                //外部订单号
                cancelOrderBO.setOutObjId(Long.parseLong(obj.getSaleOrderNoExt()));
                //供应商编码
                cancelOrderBO.setSupplierId(obj.getSupId());
                //任务id
                cancelOrderBO.setTaskId(obj.getTaskId());
                return cancelOrderBO;
            }).collect(Collectors.toList()));
        }

        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
