package com.tydic.dyc.oc.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.cert.X509Certificate;

/**
 * 标题:SslClientUtil
 * 说明:HTTP请求工具
 * 时间:2021/4/19 下午5:21
 * 作者:罗有
 */
@Slf4j
public class SslClientUtil extends DefaultHttpClient {

    public SslClientUtil() throws Exception {
        super();
        //传输协议需要根据自己的判断
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager() {
            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = this.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", 443, ssf));
    }

    public static String doPost(String url, String body) {
        String charset = "utf-8";
        org.apache.http.client.HttpClient httpClient;
        HttpPost httpPost;
        String result = null;
        try {
            httpClient = new SslClientUtil();
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("oapkey", UocOrderPropertiesUtil.getProperty("oapkey"));
            httpPost.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("POST请求异常:{}", ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        org.apache.http.client.HttpClient httpClient;
        HttpPost httpPost;
        String result = null;
        try {
            httpClient = new SslClientUtil();
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            if (!StringUtils.isBlank(headKey) && !StringUtils.isBlank(headValue)) {
                httpPost.setHeader(headKey, headValue);
            }
            httpPost.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("POST请求异常:{}", ex.getMessage());
        }
        return result;
    }
}
