package com.tydic.dyc.oc.components.es.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:UocEsSyncTodo
 * 说明:代办
 * 时间:2022/3/18 12:43
 * 作者:罗有
 */

@Slf4j
@Component
public class UocEsSyncTodo implements IUocEsSync {

	@Autowired
	private UocIndexConfig uocIndexConfig;

	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;

	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Autowired
	private IUocSysDictionaryModel iUocSysDictionaryModel;

	@Override
	public String indexName() {
		return uocIndexConfig.getTodoIndex();
	}

	@Override
	public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
		IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
		iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
		UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
		uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
		uocOrderTaskInstQryBo.setId(reqBo.getObjId());
		uocOrderTaskInstQryBo.setOrderId(reqBo.getOrderId());
		List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
		if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
			UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
			JSONObject orderTaskJson = JSON.parseObject(JSON.toJSONString(uocOrderTaskInst));
			Map<String, Map<String, String>> dicMap = getDic();
			Map<String, String> objTypeMap = dicMap.get(UocDicConstant.OBJ_TYPE.P_CODE);
			Map<String, String> dealTypeMap = dicMap.get(UocDicConstant.TASK_INST_DEAL_TYPE.P_CODE);
			Map<String, String> tacheCodeMap = dicMap.get(UocDicConstant.TACHE_CODE_TASK_NAME.P_CODE);
			orderTaskJson.put(UocConstant.ES_MAIN_OTHER.ORDER_NO, getOrderNo(uocOrderTaskInst));
			orderTaskJson.put(UocConstant.ES_MAIN_OTHER.TASK_NAME, tacheCodeMap.get(uocOrderTaskInst.getProcState()));

			List<UocOrderTaskDeal> orderTaskDealList = getListTaskDeal(uocOrderTaskInst);
			if (!CollectionUtils.isEmpty(orderTaskDealList)) {
				UocOrderTaskDeal uocOrderTaskDeal = orderTaskDealList.get(0);
				orderTaskJson.put(UocConstant.ES_MAIN_OTHER.OBJ_NAME, uocOrderTaskDeal.getDealName());
				if (null != uocOrderTaskDeal.getDealType()) {
					orderTaskJson.put(UocConstant.ES_MAIN_OTHER.OBJ_TYPE_STR, dealTypeMap.get(uocOrderTaskDeal.getDealType().toString()));
				}

			}
			orderTaskJson.put(UocConstant.ES_MAIN_OTHER.PROC_NAME, "流程名称");

			List<UocOrderProcInst> uocOrderProcInstList = getListProcInst(uocOrderTaskInst);
			if (!CollectionUtils.isEmpty(uocOrderProcInstList)) {
				UocOrderProcInst uocOrderProcInst = uocOrderProcInstList.get(0);
				orderTaskJson.put(UocConstant.ES_MAIN_OTHER.PROC_INST_ID, uocOrderProcInst.getProcInstId());
			}
			iUocEsSyncQryRspBo.setJsonObj(orderTaskJson);
		}
		return iUocEsSyncQryRspBo;
	}

	private String getOrderNo(UocOrderTaskInst uocOrderTaskInst) {
		if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInst.getObjType())) {
			UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
			uocSaleOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
			uocSaleOrderQryBo.setSaleOrderId(uocOrderTaskInst.getObjId());
			UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
			if (null != uocSaleOrderDo) {
				return uocSaleOrderDo.getSaleOrderNo();
			}
		}
		if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInst.getObjType())) {
			UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
			uocShipOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
			uocShipOrderQryBo.setShipOrderId(uocOrderTaskInst.getObjId());
			UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
			if (null != uocShipOrderDo) {
				return uocShipOrderDo.getShipOrderNo();
			}
		}
		if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInst.getObjType())) {
			UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
			uocChngOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
			uocChngOrderQryBo.setChngOrderId(uocOrderTaskInst.getObjId());
			UocChngOrderDo chngOrder = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
			if (null != chngOrder) {
				return chngOrder.getChngOrderNo();
			}
		}
		if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInst.getObjType())) {

		}
		return null;
	}

	/**
	 * 查询字典
	 */
	private Map<String, Map<String, String>> getDic() {
		List<String> pCodes = new ArrayList<>();
		pCodes.add(UocStateConstants.ShipOrder.P_CODE);
		pCodes.add(UocDicConstant.OBJ_TYPE.P_CODE);
		pCodes.add(UocDicConstant.TACHE_CODE_TASK_NAME.P_CODE);
		pCodes.add(UocDicConstant.TASK_INST_DEAL_TYPE.P_CODE);
		return iUocSysDictionaryModel.getDictionaryMap(pCodes);
	}

	private List<UocOrderProcInst> getListProcInst(UocOrderTaskInst uocOrderTaskInst) {
		UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
		uocOrderProcInstQryBo.setOrderId(uocOrderTaskInst.getOrderId());
		uocOrderProcInstQryBo.setObjId(uocOrderTaskInst.getObjId());
		uocOrderProcInstQryBo.setObjType(uocOrderTaskInst.getObjType());
		return iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
	}

	private List<UocOrderTaskDeal> getListTaskDeal(UocOrderTaskInst uocOrderTaskInst) {
		UocOrderTaskDealQryBo uocOrderTaskDealQryBo = new UocOrderTaskDealQryBo();
		uocOrderTaskDealQryBo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
		uocOrderTaskDealQryBo.setObjType(uocOrderTaskInst.getObjType());
		uocOrderTaskDealQryBo.setObjId(uocOrderTaskInst.getObjId());
		return iUocOrderModel.qryOrderTaskDealList(uocOrderTaskDealQryBo);
	}
}
