package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：EventConsumerSyncTransaction
 * 说明：议价单同步
 * 时间：2022/4/6 19:30
 *
 * @author 文乐
 */
@Component
@Slf4j

public class EventConsumerSyncBargainingTransaction implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncBargainingTransaction->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        //Long bargainingParentId = Long.valueOf((String) map.get("bargainingParentId"));
        // if (ObjectUtil.isNotEmpty(bargainingParentId)) {
        Object uocBargainingListObj = map.get("uocBargainingList");
        Object bargainingIdObj = map.get("bargainingId");
        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocBargainingListObj)) {
                //申请议价单
                JSONArray uocBargainingList = JSON.parseArray(JSON.toJSONString(uocBargainingListObj));
                if(ObjectUtil.isNotEmpty(uocBargainingList)){
                    for (int i = 0; i < uocBargainingList.size(); i++) {
                        JSONObject arrayJson = uocBargainingList.getJSONObject(i);
                        Long bargainingId = arrayJson.getLong("bargainingId");
                        if (bargainingId != null) {
                            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                            syncQryReqBo.setOrderId(bargainingId);
                            syncQryReqBo.setObjId(bargainingId);
                            syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
                            syncQryReqBo.setJsonObj(arrayJson);
                            saleList.add(syncQryReqBo);
                        }
                    }
                }
                if (ObjectUtil.isNotEmpty(saleList)) {
                    IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                    eventReqBo.setIndexName(uocIndexConfig.getBargainingIndex());
                    eventReqBo.setDataList(saleList);
                    retList.add(eventReqBo);
                }
          //  }
        }else if (ObjectUtil.isNotEmpty(bargainingIdObj)){
                Long bargainingId = UocRu.parseLong(bargainingIdObj);
                //更新议价单
                IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                syncQryReqBo.setOrderId(bargainingId);
                syncQryReqBo.setObjId(bargainingId);
                syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
                saleList.add(syncQryReqBo);
                IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                eventReqBo.setIndexName(uocIndexConfig.getBargainingIndex());
                eventReqBo.setDataList(saleList);
                retList.add(eventReqBo);
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_CREATE_BARGAINING_SYNC;
    }
}
