package com.tydic.dyc.oc.model.insporder;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：UocInspOrderItemTempDo
 * 说明：临时验收明细
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocInspOrderItemTempDo implements Serializable {
	private static final long serialVersionUID =  2302859121656758241L;

	/**
	 * 临时验收单号
	 */
	private Long tempInspOrderItemId;

	/**
	 * 临时验收单id
	 */
	private Long tempInspOrderId;

	/**
	 * 销售明细id
	 */
	private Long saleOrderItemId;

	/**
	 * 销售单id
	 */
	private Long saleOrderId;

	/**
	 * 订单id
	 */
	private Long orderId;

	/**
	 * sap订单编号
	 */
	private String sapOrderNo;

	/**
	 * sap订单明细编号
	 */
	private String sapOrderItemNo;

	/**
	 * 发货数量
	 */
	private BigDecimal sendCount;

	/**
	 * 验收数量
	 */
	private BigDecimal inspCount;

	/**
	 * 退货数量
	 */
	private BigDecimal returnCount;

	/**
	 * 状态0 异常验收  1 已验收
	 */
	private Integer status;

	/**
	 * 创建时间
	 */
	private Date createTime;

	/**
	 * 更新时间
	 */
	private Date updateTime;

	/**
	 * 备注
	 */
	private String remark;

}
