package com.tydic.dyc.oc.model.saleorder.sub;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UocSapOrderSendInfo implements Serializable {
    private static final long serialVersionUID = 3585898824966226004L;
    /**
     * sap订单推送记录id
     */
    private Long sendInfoId;
    /**
     * 订单 id
     */
    private Long orderId;
    /**
     * 销售单 id
     */
    private Long saleOrderId;
    /**
     * 能力平台能力名
     */
    private String platformName;
    /**
     * 能力平台流水号
     */
    private String platformNo;
    /**
     * 状态 1 推送成功 2 推送失败 3 回调失败 4 回调成功
     */
    private Integer status;
    /**
     * 推送类型：1 sap订单创建推送 2 sap订单取消推送
     */
    private Integer pushType;
    /**
     * 推送sap回调报文
     */
    private String pushRspParam;
    /**
     * sap 回调报文
     */
    private String sapRspParam;
    /**
     * 失败原因/请求返回
     */
    private String reason;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
}
