package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceBySaleOrderTransaction;
import com.tydic.dyc.oc.transactionservice.UocEcArrvalAcceptanceTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 标题:UocEcArrvalAcceptanceServiceImpl
 * 说明:TODO
 * 时间:2022/4/7 15:16
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class UocEcArrvalAcceptanceServiceImpl implements UocEcArrvalAcceptanceService {
    @Autowired
    private UocEcArrvalAcceptanceTransaction uocEcArrvalAcceptanceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocEcArrvalAcceptanceRspBo dealEcArrvalAcceptance(UocEcArrvalAcceptanceReqBo reqBo) {
        // 入参校验
        UocEcArrvalAcceptanceRspBo rspBo = uocEcArrvalAcceptanceTransaction.dealEcArrvalAcceptance(reqBo);
    
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }
    private void syncEs(UocEcArrvalAcceptanceReqBo reqBo, UocEcArrvalAcceptanceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
    
        list.add(saleBo);
        
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
    
        list.add(inspBo);
        
        for (UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo : rspBo.getShipOrderList()) {
            SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
            shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipBo.setOrderId(reqBo.getOrderId());
            shipBo.setObjId(uocCreateInspOrderReqShipBo.getShipOrderId());
            shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipBo);
        }
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
