package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocInspTempAfProcessTaskDo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocInspTempAfProcessTaskExecuteServiceImpl
 * 说明：临时验收售后处理任务执行接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocInspTempAfProcessTaskExecuteServiceImpl implements UocInspTempAfProcessTaskExecuteService {

    /**
     * 售后单模型层
     */
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    /**
     * 执行临时验收售后处理任务
     */
    @Override
    public UocInspTempAfProcessTaskExecuteRspBo executeInspTempAfProcessTask(UocInspTempAfProcessTaskExecuteReqBo reqBo) {
        //入参转换
        UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo = UocRu.js(reqBo, UocInspTempAfProcessTaskDo.class);

        //调用售后单模型层，执行临时验收售后处理任务
        this.iUocAfOrderModel.executeInspTempAfProcessTask(uocInspTempAfProcessTaskDo);

        //出参
        return UocRu.success(UocInspTempAfProcessTaskExecuteRspBo.class);
    }
}
