package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfterOrderListReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfterOrderListRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @description 领域服务-售后服务的列表查询
 * @author Luokan
 * @date 2022-09-29 12:25 PM
 **/
@HTServiceImpl
public class UocQryAfterOrderListServiceImpl implements UocQryAfterOrderListService {

    /**
     *  售后服务的model
     */
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Override
    public UocQryAfterOrderListRspBO qryAfterOrderList(UocQryAfterOrderListReqBO reqBo) {
        UocQryAfterOrderListRspBO rspBO = UocRu.success(UocQryAfterOrderListRspBO.class);
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        BeanUtils.copyProperties(reqBo, uocAfOrderQryBo);
        List<UocAfOrder> afOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        if (!CollectionUtils.isEmpty(afOrderList)) {
            rspBO.setAfOrderList(JSON.parseArray(JSON.toJSONString(afOrderList), UocAfOrderBO.class));
        }
        return rspBO;
    }
}
