package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderInterLog;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @description 外部系统接口调用日志插入领域服务实现类
 * @author Luokan
 * @date 2022/12/8
 **/
@HTServiceImpl
public class UocAddOrderInterLogServiceImpl implements UocAddOrderInterLogService{

    @Autowired
    private IUocOrderModel iUocOrderModel;

    /**
     * @description 外部系统接口调用日志插入
     * @author Luokan
     * @date 2022/12/8
     **/
    @Override
    public UocAddOrderInterLogRspBO addOrderInterLog(UocAddOrderInterLogReqBO reqBO) {

        UocOrderInterLog uocOrderInterLog = new UocOrderInterLog();
        BeanUtils.copyProperties(reqBO, uocOrderInterLog);
        uocOrderInterLog.setId(IdUtil.nextId());
        uocOrderInterLog.setCreateTime(new Date());
        iUocOrderModel.insertOrderInterLog(uocOrderInterLog);
        return UocRu.success(UocAddOrderInterLogRspBO.class);
    }
}
