package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocAuditOrderCancelServiceTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocAuditOrderCancelServiceImpl
 * 说明:
 * 时间:2023/9/20 16:00
 * 作者:田桂银
 */
@HTServiceImpl
@Slf4j
public class UocAuditOrderCancelServiceImpl implements UocAuditOrderCancelService {

    @Autowired
    private UocAuditOrderCancelServiceTransaction uocAuditOrderCancelServiceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocAuditOrderCancelServiceRspBo cancelAuditOrder(UocAuditOrderCancelServiceReqBo reqBo) {
        UocAuditOrderCancelServiceRspBo rspBo = uocAuditOrderCancelServiceTransaction.cancelAuditOrder(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocAuditOrderCancelServiceReqBo reqBo, UocAuditOrderCancelServiceRspBo rspBo) {
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getApprovalOrderPlusIndex());
        orderBo.setOrderId(rspBo.getOrderId());
        orderBo.setObjId(rspBo.getAuditOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(orderBo));
    }


}


