package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：发货单确认收货实现类
 */
@Slf4j
@HTServiceImpl
public class UocShipOrderConfirmReceiptServiceImpl implements UocShipOrderConfirmReceiptService {

	@Autowired
	private IUocCommonModel iUocCommonModel;

	/**
	 * 发货单确认收货
	 */
	@Override
	public UocShipOrderConfirmReceiptRspBo dealConfirmReceipt(UocShipOrderConfirmReceiptReqBo reqBo) {
		//定义出参对象
		UocShipOrderConfirmReceiptRspBo rspBo = new UocShipOrderConfirmReceiptRspBo();

		//参数校验
		this.validateParam(reqBo);

		//提交任务
		this.submitTask(reqBo);

		//出参
		rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
		rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
		return rspBo;
	}

	/**
	 * 参数校验
	 */
	private void validateParam(UocShipOrderConfirmReceiptReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
		if (ObjectUtil.isEmpty(reqBo.getTaskId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[任务ID]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getUserId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
		}
	}

	/**
	 * 提交任务
	 */
	private void submitTask(UocShipOrderConfirmReceiptReqBo reqBo){
		//定义订单公用DO
		UocCommonDo uocCommonDo = new UocCommonDo();

		//定义提交任务信息集合
		List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfoList = new ArrayList<>(1);

		//定义任务信息
		UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskInfo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
		//设置任务ID
		taskInfo.setTaskId(reqBo.getTaskId());
		//添加任务信息
		taskInfoList.add(taskInfo);

		//设置提交任务信息
		uocCommonDo.setCompleteTaskInfos(taskInfoList);
		//设置用户ID
		uocCommonDo.setUserId(reqBo.getUserId());
		//设置订单ID
		uocCommonDo.setOrderId(reqBo.getOrderId());

		//调用订单公共模型，提交任务
		this.iUocCommonModel.dealTask(uocCommonDo);
	}

}
