package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderListReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderListRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description:获取订单列表
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/28 17:12
 */
@Slf4j
@HTServiceImpl
public class UocGetSaleOrderListServiceImpl implements UocGetSaleOrderListService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocGetSaleOrderListRspBo getSaleOrderList(UocGetSaleOrderListReqBo reqBo) {
        UocGetSaleOrderListRspBo rspBo = new UocGetSaleOrderListRspBo();
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderDo> saleOrderList = iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        rspBo.setUocSaleOrderList(UocRu.jsl(saleOrderList, UocSaleOrderBO.class));
        return  rspBo;
    }

}