package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDetailBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderSingleQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderSingleQryServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderSingleQryServiceRspDetailBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单主体查询（单条）实现〉
 * @author : yuhao
 * @date : 2022/7/20 13:39
 */
@HTServiceImpl
public class UocSaleOrderSingleQryServiceImpl implements UocSaleOrderSingleQryService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocSaleOrderSingleQryServiceRspBo qrySaleOrder(UocSaleOrderSingleQryServiceReqBo reqBo) {
        UocSaleOrderSingleQryServiceRspBo rspBo = UocRu.success(UocSaleOrderSingleQryServiceRspBo.class);
        //入参校验
        this.validateParam(reqBo);
        //查询销售单主体信息
        UocSaleOrderQryBo queryUocSaleOrderQryBo = new UocSaleOrderQryBo();
        BeanUtils.copyProperties(reqBo,queryUocSaleOrderQryBo);
        UocSaleOrderDo saleOrderInfoDo = this.iUocSaleOrderModel.qrySaleOrder(queryUocSaleOrderQryBo);
        if(null != saleOrderInfoDo){
            UocSaleOrderSingleQryServiceRspDetailBo saleOrderMainInfo = new UocSaleOrderSingleQryServiceRspDetailBo();
            BeanUtils.copyProperties(saleOrderInfoDo,saleOrderMainInfo);
            //查询销售单主体扩展信息
            UocSaleOrderMapQryBo queryUocSaleOrderMapBo = new UocSaleOrderMapQryBo();
            BeanUtils.copyProperties(reqBo,queryUocSaleOrderMapBo);
            List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(queryUocSaleOrderMapBo);
            if(!CollectionUtils.isEmpty(saleOrderExpandList)){
                List<UocBaseExtParallelDetailBo> saleOrderExtList = JSONArray.parseArray(JSON.toJSONString(saleOrderExpandList)).toJavaList(UocBaseExtParallelDetailBo.class);
                saleOrderMainInfo.setSaleOrderExtList(saleOrderExtList);
            }
            rspBo.setSaleOrderBo(saleOrderMainInfo);
            return rspBo;
        }else{
            return rspBo;
        }
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void validateParam(UocSaleOrderSingleQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}


