/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.ordSourceProcessor;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UocOrderSourceProcessorManager {
    private static final Logger log = LoggerFactory.getLogger(UocOrderSourceProcessorManager.class);
    private final Map<Integer, UocOrderSourceProcessor> manageMap = new ConcurrentHashMap<Integer, UocOrderSourceProcessor>();

    public void register(UocOrderSourceProcessor intObj) {
        Integer skuSource = intObj.skuSource();
        Assert.notNull((Object)intObj, (String)"intObj can not be null");
        Assert.notNull((Object)skuSource, (String)"skuSource can not be null");
        UocOrderSourceProcessor intRet = this.manageMap.get(skuSource);
        if (intRet != null) {
            throw new BaseBusinessException("8888", "\u4e0d\u540c\u8ba2\u5355\u6765\u6e90\u5b9e\u73b0\u7c7b(" + skuSource + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info(UocOrderSourceProcessorManager.class.getSimpleName() + ".register\u6ce8\u518c\u4e86\u8ba2\u5355\u6765\u6e90\u5b9e\u73b0\u7c7b\uff1a" + skuSource);
        this.manageMap.put(skuSource, intObj);
    }

    public UocOrderSourceProcessor getInstance(Integer skuSource) {
        UocOrderSourceProcessor intRet = this.manageMap.get(skuSource);
        if (intRet == null) {
            throw new BaseBusinessException("8888", "\u8ba2\u5355\u6765\u6e90\u5b9e\u73b0\u7c7b(" + skuSource + ")\u4e0d\u5b58\u5728\uff01");
        }
        return intRet;
    }
}

