/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.service.saleorder.UocDealBackSapOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocBackSapOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealBackSapOrderService"})
public class UocDealBackSapOrderServiceImpl
implements UocDealBackSapOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"dealBackSapOrder"})
    public UocDealBackSapOrderRspBO dealBackSapOrder(@RequestBody UocDealBackSapOrderReqBO reqBO) {
        UocDealBackSapOrderRspBO rspBO = UocRu.success(UocDealBackSapOrderRspBO.class);
        if (UocConstant.SapPushType.TYPE_1.equals(reqBO.getPushType())) {
            this.doTypeOne(reqBO);
        } else if (UocConstant.SapPushType.TYPE_2.equals(reqBO.getPushType())) {
            this.doTypeTwo(reqBO);
        } else if (UocConstant.SapPushType.TYPE_3.equals(reqBO.getPushType())) {
            this.doTypeSth(reqBO, rspBO);
        }
        return rspBO;
    }

    private void doTypeSth(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        String failValue = null;
        for (UocBackSapOrderBO bo2 : reqBO.getRows()) {
            if (null == bo2.getVAULE() || "".equals(bo2.getVAULE())) continue;
            failValue = bo2.getVAULE();
        }
        Integer status = UocConstant.SapSendInfoStatus.STATUS_4;
        rspBO.setFlowFlag(Boolean.valueOf(true));
        if (null != failValue) {
            status = UocConstant.SapSendInfoStatus.STATUS_3;
            rspBO.setFlowFlag(Boolean.valueOf(false));
        }
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderNo(((UocBackSapOrderBO)reqBO.getRows().get(0)).getZDDH());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (!"XS_QR_EDQR".equals(result.getSaleOrderState()) && !"XS_QR_PDQR".equals(result.getSaleOrderState())) {
            return;
        }
        if (UocConstant.SapSendInfoStatus.STATUS_4.equals(status)) {
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(result.getOrderId());
            qryInst.setObjId(result.getSaleOrderId());
            qryInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
            rspBO.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            Map saleOrderItemMap = reqBO.getRows().stream().collect(Collectors.toMap(bo -> Long.valueOf(bo.getZDDI()), Function.identity()));
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemListByItemIds(new ArrayList<Long>(saleOrderItemMap.keySet()));
            for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                UocBackSapOrderBO sapItem = (UocBackSapOrderBO)saleOrderItemMap.get(saleOrderItem.getSaleOrderItemId());
                UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
                updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                updateSaleOrderItem.setSapOrderNo(sapItem.getEBELN());
                updateSaleOrderItem.setSapOrderItemNo(sapItem.getEBELP());
                this.iUocSaleOrderModel.modifyItemPlan(updateSaleOrderItem);
            }
        }
        UocSapOrderSendInfo qryUocSapOrderSendInfo = new UocSapOrderSendInfo();
        qryUocSapOrderSendInfo.setOrderId(result.getOrderId());
        qryUocSapOrderSendInfo.setSaleOrderId(result.getSaleOrderId());
        qryUocSapOrderSendInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_1);
        qryUocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_3);
        List<UocSapOrderSendInfo> sapSendInfoList = this.iUocSaleOrderModel.getSapSendInfoList(qryUocSapOrderSendInfo);
        UocSapOrderSendInfo updateUocSapOrderSendInfo = new UocSapOrderSendInfo();
        updateUocSapOrderSendInfo.setSendInfoId(sapSendInfoList.get(0).getSendInfoId());
        updateUocSapOrderSendInfo.setOrderId(sapSendInfoList.get(0).getOrderId());
        updateUocSapOrderSendInfo.setSaleOrderId(sapSendInfoList.get(0).getSaleOrderId());
        updateUocSapOrderSendInfo.setStatus(status);
        updateUocSapOrderSendInfo.setSapRspParam(JSON.toJSONString((Object)reqBO.getRows()));
        updateUocSapOrderSendInfo.setReason(failValue);
        updateUocSapOrderSendInfo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateSapSendInfo(updateUocSapOrderSendInfo);
    }

    private void doTypeTwo(UocDealBackSapOrderReqBO reqBO) {
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
        selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
        selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBO.getOrderId());
        qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
        qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> auditOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_2);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(new Date());
        uocSapOrderSendInfo.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        uocSapOrderSendInfo.setSaleOrderName(saleOrderDo.getSaleOrderName());
        uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(auditOrderTaskInsts.get(0).getDealOperId()));
        uocSapOrderSendInfo.setPurchaseUserName(auditOrderTaskInsts.get(0).getDealOperName());
        uocSapOrderSendInfo.setPurchaseOrgId(Long.valueOf(saleOrderDo.getStakeholder().getPurOrgId()));
        uocSapOrderSendInfo.setPurchaseOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        uocSapOrderSendInfo.setPurUserName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setPurUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
        uocSapOrderSendInfo.setSupplierId(Long.valueOf(saleOrderDo.getStakeholder().getSupId()));
        uocSapOrderSendInfo.setSupplierName(saleOrderDo.getStakeholder().getSupName());
        uocSapOrderSendInfo.setPurCompanyId(saleOrderDo.getStakeholder().getPurCompanyId());
        uocSapOrderSendInfo.setPurCompanyName(saleOrderDo.getStakeholder().getPurCompanyName());
        uocSapOrderSendInfo.setCreateOrderName(saleOrderDo.getCreateOperName());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }

    private void doTypeOne(UocDealBackSapOrderReqBO reqBO) {
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
        selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
        selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBO.getOrderId());
        qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
        qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> auditOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(new Date());
        uocSapOrderSendInfo.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        uocSapOrderSendInfo.setSaleOrderName(saleOrderDo.getSaleOrderName());
        uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(auditOrderTaskInsts.get(0).getDealOperId()));
        uocSapOrderSendInfo.setPurchaseUserName(auditOrderTaskInsts.get(0).getDealOperName());
        uocSapOrderSendInfo.setPurchaseOrgId(Long.valueOf(saleOrderDo.getStakeholder().getPurOrgId()));
        uocSapOrderSendInfo.setPurchaseOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        uocSapOrderSendInfo.setPurUserName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setPurUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
        uocSapOrderSendInfo.setSupplierId(Long.valueOf(saleOrderDo.getStakeholder().getSupId()));
        uocSapOrderSendInfo.setSupplierName(saleOrderDo.getStakeholder().getSupName());
        uocSapOrderSendInfo.setPurCompanyId(saleOrderDo.getStakeholder().getPurCompanyId());
        uocSapOrderSendInfo.setPurCompanyName(saleOrderDo.getStakeholder().getPurCompanyName());
        uocSapOrderSendInfo.setCreateOrderName(saleOrderDo.getCreateOperName());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }
}

