/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapArrivalInspInfo;
import com.tydic.dyc.oc.service.saleorder.UocDealSapInspInfoService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapInspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealSapInspInfoService"})
public class UocDealSapInspInfoServiceImpl
implements UocDealSapInspInfoService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"dealSapInspInfo"})
    public UocDealSapInspInfoRspBO dealSapInspInfo(@RequestBody UocDealSapInspInfoReqBO reqBO) {
        UocDealSapInspInfoRspBO rspBO = UocRu.success(UocDealSapInspInfoRspBO.class);
        List<String> sapOrderItemNoList = reqBO.getRows().stream().map(UocSapInspBO::getEBELP).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSapOrderItemNoList(sapOrderItemNoList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            Map saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSapOrderItemNo, Function.identity()));
            ArrayList<UocSapArrivalInspInfo> list = new ArrayList<UocSapArrivalInspInfo>();
            for (UocSapInspBO bo : reqBO.getRows()) {
                UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)((Object)saleOrderItemMap.get(bo.getEBELP()));
                UocSapArrivalInspInfo uocSapArrivalInspInfo = this.setSapArrivalInsp(bo, reqBO, saleOrderItem);
                list.add(uocSapArrivalInspInfo);
                this.dealTempInsp(saleOrderItem, uocSapArrivalInspInfo);
            }
            rspBO.setOrderId(saleOrderItemList.get(0).getOrderId());
            rspBO.setSaleOrderId(saleOrderItemList.get(0).getSaleOrderId());
        }
        return rspBO;
    }

    private void dealTempInsp(UocSaleOrderItem saleOrderItem, UocSapArrivalInspInfo uocSapArrivalInspInfo) {
        UocInspOrderTemporarily qryInspTemp = new UocInspOrderTemporarily();
        qryInspTemp.setOrderId(saleOrderItem.getOrderId());
        qryInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
        List<UocInspOrderTemporarily> resultInspTemp = this.iUocSaleOrderModel.selectTempInspOrderList(qryInspTemp);
        Long inspOrderTempId = null;
        if (CollectionUtils.isEmpty(resultInspTemp)) {
            UocInspOrderTemporarily insertInspTemp = new UocInspOrderTemporarily();
            insertInspTemp.setTempInspOrderId(IdUtil.nextId());
            inspOrderTempId = insertInspTemp.getTempInspOrderId();
            insertInspTemp.setTempInspOrderNo("");
            insertInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspTemp.setOrderId(insertInspTemp.getOrderId());
            insertInspTemp.setStatus(UocConstant.TempInspOrderStatus.ERROR);
            insertInspTemp.setCreateTime(new Date());
            insertInspTemp.setRemark(uocSapArrivalInspInfo.getInspRemark());
            this.iUocSaleOrderModel.insertTempInspOrder(insertInspTemp);
        } else {
            inspOrderTempId = resultInspTemp.get(0).getTempInspOrderId();
        }
        UocInspOrderItemTemporarily qryInspItemTepm = new UocInspOrderItemTemporarily();
        qryInspItemTepm.setOrderId(saleOrderItem.getOrderId());
        qryInspItemTepm.setSaleOrderId(saleOrderItem.getSaleOrderId());
        qryInspItemTepm.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
        List<UocInspOrderItemTemporarily> resultInspItemTemp = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryInspItemTepm);
        if (CollectionUtils.isEmpty(resultInspItemTemp)) {
            UocInspOrderItemTemporarily insertInspItemTemp = new UocInspOrderItemTemporarily();
            insertInspItemTemp.setTempInspOrderItemId(IdUtil.nextId());
            insertInspItemTemp.setTempInspOrderId(inspOrderTempId);
            insertInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            insertInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspItemTemp.setOrderId(saleOrderItem.getSaleOrderId());
            insertInspItemTemp.setSapOrderNo(saleOrderItem.getSapOrderNo());
            insertInspItemTemp.setSapOrderItemNo(saleOrderItem.getSapOrderItemNo());
            insertInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            insertInspItemTemp.setInspCount(uocSapArrivalInspInfo.getInspCount());
            insertInspItemTemp.setReturnCount(BigDecimal.ZERO);
            insertInspItemTemp.setStatus(1);
            insertInspItemTemp.setCreateTime(new Date());
            this.iUocSaleOrderModel.insertTempInspOrderItem(insertInspItemTemp);
        } else {
            UocInspOrderItemTemporarily updateInspItemTemp = new UocInspOrderItemTemporarily();
            updateInspItemTemp.setOrderId(saleOrderItem.getOrderId());
            updateInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateInspItemTemp.setInspCount(resultInspItemTemp.get(0).getInspCount().add(uocSapArrivalInspInfo.getInspCount()));
            updateInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            updateInspItemTemp.setUpdateTime(new Date());
            this.iUocSaleOrderModel.updateTempInspOrderItem(updateInspItemTemp);
        }
    }

    private UocSapArrivalInspInfo setSapArrivalInsp(UocSapInspBO bo, UocDealSapInspInfoReqBO reqBO, UocSaleOrderItem saleOrderItem) {
        UocSapArrivalInspInfo uocSapArrivalInspInfo = new UocSapArrivalInspInfo();
        uocSapArrivalInspInfo.setInspInfoId(IdUtil.nextId());
        uocSapArrivalInspInfo.setSapOrderNo(bo.getEBELN());
        uocSapArrivalInspInfo.setSapOrderItemNo(bo.getEBELP());
        uocSapArrivalInspInfo.setPlanInspCount(new BigDecimal(bo.getMENGE()));
        BigDecimal sacle = BigDecimal.ZERO;
        if (null != saleOrderItem.getUnitDigit()) {
            sacle = new BigDecimal(saleOrderItem.getUnitDigit());
        }
        BigDecimal inspCount = uocSapArrivalInspInfo.getPlanInspCount().divide(saleOrderItem.getPlanConversionRate(), sacle.intValue(), RoundingMode.HALF_UP);
        uocSapArrivalInspInfo.setInspCount(inspCount);
        uocSapArrivalInspInfo.setInspOperName(bo.getUSNAM_MKPF());
        uocSapArrivalInspInfo.setStatus(1);
        uocSapArrivalInspInfo.setSapVoucherNo(bo.getMBLNR());
        uocSapArrivalInspInfo.setSapVoucherItemNo(bo.getZEILE());
        uocSapArrivalInspInfo.setMaterialCode(bo.getMATNR());
        uocSapArrivalInspInfo.setInspTime(bo.getCPUDT_MKFP());
        uocSapArrivalInspInfo.setInspRemark(bo.getXBLNR_MKPF());
        uocSapArrivalInspInfo.setPlatformName(reqBO.getPlatformName());
        uocSapArrivalInspInfo.setPlatformNo(reqBO.getPlatformNo());
        uocSapArrivalInspInfo.setCreateTime(new Date());
        return uocSapArrivalInspInfo;
    }
}

