/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfInspection;
import com.tydic.dyc.oc.model.order.sub.UocConfInspectionUse;
import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleGoodsAfterTakeTypeBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemPlanBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItemPlan;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapArrivalInspInfo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapSendOrderLog;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocSaleOrderModelImpl
implements IUocSaleOrderModel {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderModelImpl.class);
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocAgreementOrderRepository uocAgreementOrderRepository;
    @Autowired
    private UocOrderRepository uocOrderRepository;
    @Value(value="${isLimitPrice:true}")
    private boolean limitPrice;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        List<UocOrderAccessory> list;
        List<UocSaleOrderMap> saleOrderMapList;
        this.validateCreateArg(saleOrderDo);
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderNo())) {
            saleOrderDo.setSaleOrderNo(this.genRequestCode(saleOrderDo));
        }
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderId())) {
            saleOrderDo.setSaleOrderId(IdUtil.nextId());
        }
        if (null == saleOrderDo.getCreateTime()) {
            saleOrderDo.setCreateTime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderState())) {
            saleOrderDo.setSaleOrderState(null);
        }
        if (null != saleOrderDo.getSaleOrderItems().get(0).getAgrBo()) {
            saleOrderDo.setContractNo(saleOrderDo.getSaleOrderItems().get(0).getAgrBo().getContractNo());
        }
        if (ObjectUtil.isNotEmpty(saleOrderMapList = saleOrderDo.getSaleOrderMapList())) {
            Map<String, UocSaleOrderMap> baseExtendFieldBoMap = saleOrderMapList.stream().collect(Collectors.toMap(UocSaleOrderMap::getFieldCode, e -> e));
            if (ObjectUtil.isNotEmpty((Object)baseExtendFieldBoMap.get("budgetModelCode")) && "3".equals(baseExtendFieldBoMap.get("budgetModelCode").getFieldValue()) && UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
                saleOrderDo.setSaleOrderState("XS_QR_DQR");
            }
            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setOrderId(saleOrderDo.getOrderId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }
        List<UocSaleOrderPayConf> saleOrderPayConfList = saleOrderDo.getSaleOrderPayConfList();
        Integer modelSettle = saleOrderDo.getModelSettle();
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
            for (UocSaleOrderPayConf uocSaleOrderPayConf : saleOrderPayConfList) {
                uocSaleOrderPayConf.setId(IdUtil.nextId());
                uocSaleOrderPayConf.setOrderId(saleOrderDo.getOrderId());
                uocSaleOrderPayConf.setCreateTime(saleOrderDo.getCreateTime());
                uocSaleOrderPayConf.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderPayConf.setSaleOrderId(saleOrderDo.getSaleOrderId());
                if (!UocDicConstant.PAY_CONF_USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType())) continue;
                saleOrderDo.setPayType(uocSaleOrderPayConf.getPayType() != null ? uocSaleOrderPayConf.getPayType().toString() : null);
            }
        }
        if (ObjectUtil.isNotEmpty(list = saleOrderDo.getSaleOrderAccessoryList())) {
            for (UocOrderAccessory accessory : list) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
        this.setSaleItems(saleOrderDo);
        this.setAfterTakeType(saleOrderDo);
        if (this.limitPrice && !saleOrderDo.getSplitCreateOrder().booleanValue()) {
            BigDecimal bigDecimal2 = saleOrderDo.getTotalSaleFee();
            bigDecimal2 = bigDecimal2.multiply(new BigDecimal(10000));
            String supNo = saleOrderDo.getStakeholder().getSupId();
            String supName = saleOrderDo.getStakeholder().getSupName();
            log.info("\u4f9b\u5e94\u5546 {}\uff0c\u4e0b\u5355\u91d1\u989d\u4e3a {}", (Object)supNo, (Object)bigDecimal2);
            UocConfSupplier uocConfSupplier = new UocConfSupplier();
            uocConfSupplier.setSupNo(Long.valueOf(supNo));
            uocConfSupplier.setLimitStatus(0);
            uocConfSupplier = this.uocOrderRepository.getConfSupplierModelBy(uocConfSupplier);
            UocConfSupplier uocConfSupplier1 = new UocConfSupplier();
            uocConfSupplier1.setSupNo(0L);
            uocConfSupplier1.setLimitStatus(0);
            uocConfSupplier1.setBusinessTypeCode(String.valueOf(saleOrderDo.getOrderSource()));
            uocConfSupplier1 = this.uocOrderRepository.getConfSupplierModelBy(uocConfSupplier1);
            UocConfSupplier uocConfSupplier2 = uocConfSupplier = Objects.nonNull(uocConfSupplier) ? uocConfSupplier : uocConfSupplier1;
            if (ObjectUtil.isNotEmpty((Object)uocConfSupplier)) {
                Long limit = uocConfSupplier.getOrderLimit();
                log.info("\u8ba2\u5355\u9650\u989d\uff1a{}", (Object)limit);
                if (limit != null && limit > 0L && limit > bigDecimal2.longValue()) {
                    String money = null;
                    try {
                        money = UocMoneyUtil.long2BigDecimal(limit).toString();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw new BaseBusinessException("UOCS00001", supName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
                }
            }
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
            if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderItems().get(0).getManagementOrgId())) {
                saleOrderDo.setManagementOrgId(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgId());
                saleOrderDo.setManagementOrgName(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgName());
            }
        } else {
            UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
            uocSaleStakeholderQryBo.setStakeholderId(saleOrderDo.getStakeholderId());
            UocSaleStakeholder saleOrderStakeholder = this.uocSaleOrderRepository.getSaleOrderStakeholder(uocSaleStakeholderQryBo);
            if (ObjectUtil.isNotEmpty((Object)saleOrderStakeholder)) {
                saleOrderDo.setManagementOrgId(saleOrderStakeholder.getSupId());
                saleOrderDo.setManagementOrgName(saleOrderStakeholder.getSupName());
            }
        }
        return this.uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if (ObjectUtil.isEmpty((Object)((Object)saleOrderDo))) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            List<UocConfInspectionUse> uocConfInspectionUses;
            UocConfInspectionUse uocConfInspectionUse;
            List<UocSaleItemMap> saleItemMapList;
            List<UocOrderAccessory> saleOrderAccessoryList;
            saleOrderItem.setBargainingId(saleOrderDo.getBargainingId());
            saleOrderItem.setBargainingNo(saleOrderDo.getBargainingNo());
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSaleOrderItemId())) {
                saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            }
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            saleOrderItem.setPurchaseFee(saleOrderItem.getPurchasePrice().multiply(saleOrderItem.getPurchaseCount()));
            saleOrderItem.setSaleFee(saleOrderItem.getSalePrice().multiply(saleOrderItem.getPurchaseCount()));
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getCmpOrderNo())) {
                saleOrderItem.setCmpOrderNo(null);
            }
            if (ObjectUtil.isNotEmpty(saleOrderAccessoryList = saleOrderItem.getAttachBos())) {
                for (UocOrderAccessory uocOrderAccessory : saleOrderAccessoryList) {
                    uocOrderAccessory.setId(IdUtil.nextId());
                    uocOrderAccessory.setObjId(saleOrderItem.getSaleOrderItemId());
                    uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE_ITEM);
                    uocOrderAccessory.setOrderId(saleOrderDo.getOrderId());
                    uocOrderAccessory.setCreateTime(saleOrderDo.getCreateTime());
                    uocOrderAccessory.setCreateOperId(saleOrderDo.getCreateOperId());
                    uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.AGR_ITEM_WEIGHT);
                }
            }
            if (ObjectUtil.isNotEmpty(saleItemMapList = saleOrderItem.getSaleItemMapList())) {
                for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                    uocSaleItemMap.setId(IdUtil.nextId());
                    uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                    uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                    uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                    uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
                }
            }
            if (saleOrderItem.getSkuSource().equals(UocConstant.SkuSource.ELC)) continue;
            UocConfInspection uocConfInspection = new UocConfInspection();
            Integer inspectionType = null;
            Integer busiType = null;
            if (saleOrderItem.getSkuSource().equals(UocConstant.SkuSource.SELF)) {
                uocConfInspectionUse = new UocConfInspectionUse();
                uocConfInspectionUse.setBusiType(3);
                uocConfInspectionUses = this.uocOrderRepository.qryInspectionConfigUseList(uocConfInspectionUse);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(uocConfInspectionUses)) {
                    inspectionType = uocConfInspectionUses.get(0).getInspectionType();
                    busiType = 3;
                }
            } else if (saleOrderItem.getSkuSource().equals(UocConstant.SkuSource.AGR)) {
                uocConfInspectionUse = new UocConfInspectionUse();
                uocConfInspectionUse.setBusiType(1);
                uocConfInspectionUses = this.uocOrderRepository.qryInspectionConfigUseList(uocConfInspectionUse);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(uocConfInspectionUses)) {
                    inspectionType = uocConfInspectionUses.get(0).getInspectionType();
                    busiType = 1;
                }
            }
            if (busiType == null || inspectionType == null) continue;
            uocConfInspection.setBusiType(busiType);
            uocConfInspection.setInspectionType(inspectionType);
            List<UocConfInspection> uocConfInspections = this.uocOrderRepository.qryInspectionConfigList(uocConfInspection);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uocConfInspections)) continue;
            if (uocConfInspections.get(0).getInspectionType().equals(UocConstant.INSPECTION_TYPE_ALL)) {
                saleOrderItem.setInspectionExcessPercent(uocConfInspections.get(0).getExcessPercent());
                continue;
            }
            Map<String, List<UocConfInspection>> commodityTypeMap = uocConfInspections.stream().collect(Collectors.groupingBy(UocConfInspection::getCommodityType));
            saleOrderItem.setInspectionExcessPercent(commodityTypeMap.get(saleOrderItem.getCommodityTypeId()) == null ? 0 : commodityTypeMap.get(saleOrderItem.getCommodityTypeId()).get(0).getExcessPercent());
        }
    }

    private void setAfterTakeType(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            List<Integer> returnTypeList = saleOrderItem.getServerReturnTypeList();
            if (!ObjectUtil.isNotEmpty(returnTypeList)) continue;
            returnTypeList.forEach(e -> {
                UocSaleGoodsAfterTakeTypeBo afterTakeTypeBo = new UocSaleGoodsAfterTakeTypeBo();
                afterTakeTypeBo.setAfterTakeType((Integer)e);
                afterTakeTypeBo.setAfterTakeId(IdUtil.nextId());
                afterTakeTypeBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                afterTakeTypeBo.setCommodityId(saleOrderItem.getCommodityId());
                this.uocSaleOrderRepository.insertCommityAfterTakeType(afterTakeTypeBo);
            });
        }
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemIds)) {
            throw new BaseBusinessException("102001", "\u9500\u552e\u5355\u660e\u7ec6id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemListByItemIds(itemIds);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return this.uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        this.validateUpdateSaleOrderArg(reqBo);
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)((Object)uocSaleOrderDo))) {
            throw new BaseBusinessException("102001", "\u8be5\u9500\u552e\u5355" + reqBo.getSaleOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        return this.uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocUpdateSaleOrderStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUpdateOperId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u66f4\u65b0\u4ebaid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355\u72b6\u6001\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        this.uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            this.uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return this.uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return this.uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return this.uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        this.uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }

    @Override
    public UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.getSaleOrderStakeholder(qryBo);
    }

    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        if (UocConstant.orderSource.ELC.equals(saleOrderDo.getOrderSource()) && UocConstant.areaType.EMPLOYEE_SUPERMARKET.equals(saleOrderDo.getAreaType())) {
            return this.uocCommonRepository.getOrderNoSingle("SALE_ORDER_NO_4");
        }
        return this.uocCommonRepository.getOrderNoSingle("SALE_ORDER_NO_" + saleOrderDo.getOrderSource());
    }

    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.addSaleOrderMap(uocSaleOrderDo);
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateBatchValue(uocSaleOrderDo);
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateInvalid(uocSaleOrderDo);
    }

    @Override
    public UocOrderAgreement getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocOrderAgreementQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocAgreementOrderRepository.getAgreementOrderBy(uocOrderAgreementQryBo);
    }

    @Override
    public List<UocOrderAgreement> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocOrderAgreementQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocAgreementOrderRepository.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    @Override
    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocSaleOrderQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qryTotalFeeAndCount(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocSaleOrderItemQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        this.valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocImplOrderItem.getSendCount()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemSendCount(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo) {
        this.valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocImplOrderItem.getArrivalTime()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5230\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemArrivalTime(convertSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo getCollectCountImplOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderItemQryBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getCollectCount(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        uocSaleOrderDo.getSaleOrderItems().forEach(uocSaleOrderItem -> {
            if (null == uocSaleOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocSaleOrderItem.getAcceptanceCount()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemInspCount(uocSaleOrderDo);
    }

    @Override
    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo.getStakeholder()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u4e09\u65b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uocSaleOrderDo.getStakeholder().getOrderId() == null) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderStakeholder(uocSaleOrderDo);
    }

    @Override
    public void modifySalePrice(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        this.valSaleItem(uocSaleOrderItem);
        this.uocSaleOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    @Override
    public void modifyBatchItemChngingCount(UocSaleOrderDo convertImplOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemChngingCount(convertImplOrderDo);
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifyBatchItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifyBatchItemReturnCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    @Override
    public void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.batchModifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    private void valSaleItem(UocSaleOrderItem uocSaleOrderItem) {
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderItem.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderItem.getSaleOrderItemId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void valDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void deleteSaleOrder(UocSaleOrderDo saleOrderDo) {
        this.deleteSaleOrderValDo(saleOrderDo);
        this.uocSaleOrderRepository.deleteSaleOrder(saleOrderDo);
    }

    @Override
    public void updateProcInst(UocOrderProcInst uocOrderProcInst) {
        this.uocCommonRepository.updateProInst(uocOrderProcInst);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        this.uocCommonRepository.updateTaskInst(uocOrderTaskInst);
    }

    private void deleteSaleOrderValDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    @Override
    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyInspSuper(uocSaleOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemRefuseCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemArriveCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        this.validateUpdateSaleItemWithOutSkuId(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateItem(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.updateItemArriveAccount(uocSaleOrderDo);
    }

    @Override
    public void modifyPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    private void validateUpdateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (ObjectUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderItems]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (saleOrderItem == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderItem]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSaleOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSkuExtSkuId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuExtSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getNakedPrice())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[NakedPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getTax())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)saleOrderItem.getTaxPrice())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TaxPrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmAdd(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirmAdd(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmReduce(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirmReduce(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderList(uocSaleOrderQryBo);
    }

    @Override
    public List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo convertSaleOrderDo) {
        return this.uocSaleOrderRepository.cancelEsOrderList(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getSaleOrders(uocSaleOrderQryBo);
    }

    @Override
    public Integer qrySaleCounts(UocSaleOrderDo uocSaleOrderDo) {
        return this.uocSaleOrderRepository.qrySaleOrderCounts(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleGoodsAfterTakeTypeBo> qryCommityTakeTypes(UocSaleGoodsAfterTakeTypeBo takeTypeBo) {
        return this.uocSaleOrderRepository.qryCommityTakeTypes(takeTypeBo);
    }

    @Override
    public List<UocSaleOrderItemPlan> selectSaleOrderItemPlan(UocSaleOrderItemPlanBo record) {
        return this.uocSaleOrderRepository.selectSaleOrderItemPlan(record);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderListByBar(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderListByBar(uocSaleOrderQryBo);
    }

    @Override
    public void batchSyncSale() {
        this.uocSaleOrderRepository.batchSyncSale();
    }

    @Override
    public void modifyItemPlan(UocSaleOrderItem saleOrderItem) {
        this.uocSaleOrderRepository.modifyItemPlan(saleOrderItem);
    }

    @Override
    public void insertSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo) {
        this.uocSaleOrderRepository.insertSapSendInfo(uocSapOrderSendInfo);
    }

    @Override
    public void updateSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo) {
        this.uocSaleOrderRepository.updateSapSendInfo(uocSapOrderSendInfo);
    }

    @Override
    public List<UocSapOrderSendInfo> getSapSendInfoList(UocSapOrderSendInfo uocSapOrderSendInfo) {
        return this.uocSaleOrderRepository.getSapSendInfoList(uocSapOrderSendInfo);
    }

    @Override
    public BasePageRspBo<UocSapSendOrderLog> getSapSendInfoListPage(UocQrySapSendOrderLogReqBO uocQrySapSendOrderLogReqBO) {
        return this.uocSaleOrderRepository.getSapSendInfoListPage(uocQrySapSendOrderLogReqBO);
    }

    @Override
    public BasePageRspBo<UocInspOrderTemporarily> selectTempInspOrderListPage(UocQryTempInspListReqBO uocQryTempInspListReqBO) {
        return this.uocSaleOrderRepository.selectTempInspOrderListPage(uocQryTempInspListReqBO);
    }

    @Override
    public int insertSapArrivalInspBatch(List<UocSapArrivalInspInfo> list) {
        return this.uocSaleOrderRepository.insertSapArrivalInspBatch(list);
    }

    @Override
    public List<UocInspOrderTemporarily> selectTempInspOrderList(UocInspOrderTemporarily uocInspOrderTemporarily) {
        return this.uocSaleOrderRepository.selectTempInspOrderList(uocInspOrderTemporarily);
    }

    @Override
    public void updateTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily) {
        this.uocSaleOrderRepository.updateTempInspOrder(uocInspOrderTemporarily);
    }

    @Override
    public void insertTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily) {
        this.uocSaleOrderRepository.insertTempInspOrder(uocInspOrderTemporarily);
    }

    @Override
    public List<UocInspOrderItemTemporarily> selectTempInspOrderItemList(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        return this.uocSaleOrderRepository.selectTempInspOrderItemList(uocInspOrderItemTemporarily);
    }

    @Override
    public void updateTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        this.uocSaleOrderRepository.updateTempInspOrderItem(uocInspOrderItemTemporarily);
    }

    @Override
    public void insertTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        this.uocSaleOrderRepository.updateTempInspOrderItem(uocInspOrderItemTemporarily);
    }
}

