package com.tydic.dyc.oc.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题：类名称:DycUocEcOrderTodoDoneMqConfig
 * 说明：置为一般mq配置
 * 时间：2022/5/20 16:09
 * 作者 @author 尹栋梁
 */
@Configuration
public class UocEcOrderTodoDoneMqConfig {

    //@Value("${uoc.ec.todo.done.pid:PID_OS_TEST_DEV_TODODONE}")
    private String uocEcOrderTodoPid;

    //@Value("${uoc.ec.todo.done.topic:OS_TEST_DEV_TODODONE_TOPIC}")
    private String uocEcOrderTodoTopic;

    //@Value("${uoc.ec.todo.done.tag:uoc_ec_todo_done}")
    private String uocEcOrderTodoTag;

    //@Value("${uoc.process.todo.tag:UOC_TODO_TAG}")
    private String uocProcessTodoTag;


    //@Bean(value = "uocEcOrderTodoProvider", initMethod = "startup", destroyMethod = "shutdown")
    public ProxyProducerFactoryBean dycUocEcOrderSyncProvider() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(uocEcOrderTodoPid);
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig(defaultProxyMessageConfig);
        return proxyProducerFactoryBean;
    }
}
