package com.tydic.dyc.oc.components.statecalculator;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 标题:UocCalculatorManager
 * 说明:订单状态计算管理器
 * 时间:2023/7/12 16:31
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocStateCalculatorManager {
    /**
     * 在系统启动时，缓存所有状态计算器
     */
    private final Map<String, UocStateCalculator> manageMap = new ConcurrentHashMap<>();

    /**
     * 注册状态计算器
     */
    public void registerUocStateCalculator(UocStateCalculator calculator) {
        String className = calculator.getClass().getName();
        log.info(UocStateCalculatorManager.class.getSimpleName() + ".registerUocStateCalculator 注册了状态计算器：" + calculator.getClass().getSimpleName());
        manageMap.put(className, calculator);
    }

    /**
     * 获取状态计算器实例
     */
    public UocStateCalculator getUocStateCalculator(String className) {
        return manageMap.get(className);
    }


}


