package com.tydic.dyc.oc.model.aforder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.UocInspTempAfProcessTaskDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.UocInspOrderItemTempDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspTempItemQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.*;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 标题:UocAfOrderModelImpl
 * 说明:售后单
 * 时间:2022/3/8 18:10
 * 作者:罗有
 */

@Service
@Slf4j
public class UocAfOrderModelImpl implements IUocAfOrderModel {
    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocSaleOrderRepository saleOrderRepository;
    @Autowired
    private UocShipOrderRepository shipOrderRepository;

    @Autowired
    private UocOrderRepository orderRepository;

    @Autowired
    private UocInspOrderRepository uocInspOrderRepository;

    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        if (ObjectUtil.isNull(uocAfOrderItemQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderList(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        if (ObjectUtil.isNull(uocAfOrderObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        if (ObjectUtil.isNull(uocAfOrderMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        if (ObjectUtil.isNull(uocAfOrderWaybillQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    @Override
    public UocAfOrderDo dealPebTheZoneAfterApplication(UocAfOrderDo afOrderDo, Integer orderSource) {
        if (ObjectUtil.isNull(afOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        afOrderDo.setAfOrderId(IdUtil.nextId());
        afOrderDo.setServState(UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION);
        afOrderDo.setWaybillFlag(0);
        UocAfOrderDo afterOrderNo = getAfterOrderNo(new UocAfOrderDo(), orderSource);
        afOrderDo.setAfServCode(afterOrderNo.getAfServCode());
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            for (UocAfOrderMap uocAfOrderMap : extParallelBoList) {
                uocAfOrderMap.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderMap.setId(IdUtil.nextId());
                uocAfOrderMap.setOrderId(afOrderDo.getOrderId());
                uocAfOrderMap.setSaleOrderId(afOrderDo.getSaleOrderId());
//                uocAfOrderMap.setShipOrderId();
            }
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            takeAddress.setContactId(IdUtil.nextId());
            takeAddress.setOrderId(afOrderDo.getOrderId());
            takeAddress.setCreateTime(new Date());
            afOrderDo.setTpContactId(takeAddress.getContactId());
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            returnAddress.setContactId(IdUtil.nextId());
            returnAddress.setOrderId(afOrderDo.getOrderId());
            returnAddress.setCreateTime(new Date());
            afOrderDo.setContactId(returnAddress.getContactId());
        }
        List<UocAfOrderObj> afOrderObjList = afOrderDo.getAfOrderObjList();
        if (ObjectUtil.isNotEmpty(afOrderObjList)) {
            for (UocAfOrderObj uocAfOrderObj : afOrderObjList) {
                uocAfOrderObj.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderObj.setId(IdUtil.nextId());
                uocAfOrderObj.setCreateTime(new Date());
                uocAfOrderObj.setOrderId(afOrderDo.getOrderId());
                uocAfOrderObj.setCreateOperId(afOrderDo.getCreateOperId());
            }
        }
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            for (UocAfOrderItem uocAfOrderItem : afOrderItemBoList) {
                uocAfOrderItem.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderItem.setAfOrderItemId(IdUtil.nextId());
            }
        }
        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            for (UocOrderAccessory uocOrderAccessory : orderAccessoryBoList) {
                uocOrderAccessory.setOrderId(afOrderDo.getOrderId());
                uocOrderAccessory.setObjId(afOrderDo.getAfOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(afOrderDo.getCreateOperId());
                uocOrderAccessory.setId(IdUtil.nextId());
            }
        }
        return uocAfOrderRepository.saveAfterOder(afOrderDo);
    }

    @Override
    public UocAfOrderDo getAfterOrderNo(UocAfOrderDo afOrderDo, Integer orderSource) {
        if (null == afOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        String orderNo = uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_AS_NO + "_" + orderSource);
        afOrderDo.setAfServCode(orderNo);
        return afOrderDo;
    }

    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        if (ObjectUtil.isNull(uocAfItemMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    @Override
    public void updateAfOrderMain(UocAfOrderDo uocAfOrderDo) {
        if (ObjectUtil.isNull(uocAfOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        uocAfOrderRepository.modifyAfOrder(uocAfOrderDo);
    }

    @Override
    public void updateBatchAfOrderMain(List<UocAfOrderDo> afOrderDos) {
        if (ObjectUtil.isNotEmpty(afOrderDos)) {
            uocAfOrderRepository.modifyBatchAfOrderRemark(afOrderDos);
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderExtOrderId(afOrderDo);
        }
    }

    @Override
    public void addWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybill.setId(IdUtil.nextId());
            uocAfOrderRepository.saveAfOrderWayBill(uocAfOrderWaybill);
        }
    }

    @Override
    public void modifyAfOrderState(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderState(afOrderDo);

            //定义售后明细查询参数
            UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
            //设置订单ID
            uocAfOrderItemQryBo.setOrderId(afOrderDo.getOrderId());
            //设置售后单ID
            uocAfOrderItemQryBo.setAfOrderId(afOrderDo.getAfOrderId());
            //调用获取售后明细
            List<UocAfOrderItem> uocAfOrderItemList = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);

            //修改临时验收明细售后信息执行
            this.modifyInspTempAfInfoExecute(afOrderDo.getServState(), uocAfOrderItemList);
        }
    }

    @Override
    public boolean confirmAfOrderState(UocAfterOrderSupplierConfirmReqBo reqBo, Integer flag, UocAfterOrderSupplierConfirmRspBo rspBo) {
        if (ObjectUtil.isNotEmpty(reqBo)) {
            UocAfOrderDo afOrderDo = new UocAfOrderDo();
            afOrderDo.setOrderId(reqBo.getOrderId());
            afOrderDo.setAfOrderId(reqBo.getAfOrderId());
            UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(afOrderDo, UocAfOrderQryBo.class);
            UocAfOrder afOrder = uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
            UocAfOrderItemQryBo uocAfOrderItemQryBo = UocRu.js(afOrderDo, UocAfOrderItemQryBo.class);
            List<UocAfOrderItem> afOrderItemList = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
            if (flag == 0) {
                //防止定时任务先消费state 1 再消费state 0
                if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(afOrder.getServState())||
                        UocDicConstant.SERVICE_STATE.COMPLATE.equals(afOrder.getServState())) {
                    log.info("售后单："+reqBo.getAfOrderId()+"已经已经消费了state1");
                    rspBo.setSaleOrderId(afOrder.getSaleOrderId());
                    return false;
                }
                //防止重复执行
                if (UocDicConstant.SERVICE_STATE.APPROVAL_PASS.equals(afOrder.getServState())) {
                    rspBo.setSaleOrderId(afOrder.getSaleOrderId());
                    return false;
                }
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.APPROVAL_PASS);
                afOrderDo.setConfirmTime(reqBo.getDateTime());
                // 如果是客户发货，通过之后可以维护发运信息
                if (UocConstant.PICKWARETYPE.CUSTOMSHIP.equals(afOrder.getPickwareType())) {
                    afOrderDo.setWaybillFlag(1);
                }
                rspBo.setSaleOrderId(afOrder.getSaleOrderId());
            } else if (flag == 1) {
                //防止重复执行
                if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(afOrder.getServState())) {
                    rspBo.setSaleOrderId(afOrder.getSaleOrderId());
                    return false;
                }
                updateAfteringCount(reqBo, afOrderItemList, afOrder, flag);
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
                afOrderDo.setWaybillFlag(0);
                //电商跳过同意售后标记售后完成，确认时间取完成时间
                if(null == afOrder.getConfirmTime()){
                    afOrderDo.setConfirmTime(reqBo.getDateTime());
                }
                /*String payType = afOrder.getPayType();
                //查询销售单状态
                UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                uocSaleOrderDo.setOrderId(afOrder.getOrderId());
                uocSaleOrderDo.setSaleOrderId(afOrder.getSaleOrderId());
                UocSaleOrderDo saleOrderMain = saleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
                Integer modelSettle = saleOrderMain.getModelSettle();*/

                /*if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(afOrder.getServType())) {
                    if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.toString().equals(payType)) {
                        afOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.AMOUNT__DUE_UPDATED);
                        //封装出参-> 需调用扣减授信
                    *//*if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(afOrder.getServType())) {
                        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
                        uocOrderStakeholderQryBo.setStakeholderId(saleOrderMain.getStakeholderId());
                        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderRepository.qryStakeholderList(uocOrderStakeholderQryBo);
                        UocOrderStakeholderQryBo uocOrderStakeholderQryBo1 = uocOrderStakeholderQryBos.get(0);
                        String purOrgId = uocOrderStakeholderQryBo1.getPurOrgId();
                        rspBo.setPurOrgId(purOrgId);
                        if (UocDicConstant.MODEL_SETTLE.TRADE.equals(modelSettle)) {
                            rspBo.setSupId(uocOrderStakeholderQryBo1.getProId());
                        } else if (UocDicConstant.MODEL_SETTLE.MATCH.equals(modelSettle)) {
                            rspBo.setSupId(uocOrderStakeholderQryBo1.getSupId());
                        }
                        rspBo.setAmount(afOrder.getRealReturnFee().negate());
                    }*//*
                    } else if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.toString().equals(payType)) {
                        afOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED);
                    }
                }*/
                buildRspBo(rspBo, afOrder, afOrderItemList, flag);
            } else if (flag == 2) {
                updateAfteringCount(reqBo, afOrderItemList, afOrder, flag);
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS);
                //如果是退货，更新付款状态为已取消
                if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(afOrder.getServType())) {
                    afOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
                }
                afOrderDo.setCancelTime(reqBo.getDateTime());
                afOrderDo.setWaybillFlag(0);
                buildRspBo(rspBo, afOrder, afOrderItemList, flag);
            }
            afOrderDo.setUpdateTime(new Date());
            uocAfOrderRepository.modifyAfOrderState(afOrderDo);

            //修改临时验收明细售后信息执行
            this.modifyInspTempAfInfoExecute(afOrderDo.getServState(), afOrderItemList);
        }
        return true;
    }

    private void buildRspBo(UocAfterOrderSupplierConfirmRspBo rspBo, UocAfOrder afOrder, List<UocAfOrderItem> afOrderItemList, Integer flag) {
        UocAfOrderItem uocAfOrderItem = afOrderItemList.get(0);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
        List<UocShipOrderItem> shipOrderItem = shipOrderRepository.getShipOrderItem(uocShipOrderItemQryBo);
        rspBo.setSaleOrderId(afOrder.getSaleOrderId());
        rspBo.setShipOrderId(shipOrderItem.get(0).getShipOrderId());
    }

    private void updateAfteringCount(UocAfterOrderSupplierConfirmReqBo reqBo, List<UocAfOrderItem> afOrderItemList, UocAfOrder afOrder, Integer flag) {
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //修改发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            Integer servType = afOrder.getServType();
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType) && flag == 1) {
                uocShipOrderItem.setReturnCount(returnCount);
                uocShipOrderItem.setArriveCount(returnCount.negate());
            }
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            shipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType) && flag == 1) {
                uocSaleOrderItem.setReturnCount(returnCount);
                uocSaleOrderItem.setArriveCount(returnCount.negate());
            }
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            saleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }
    }

    @Override
    public void modifyAfterOrderCount(UocAfterOrderFinishConfirmReqBo reqBo) {
        UocAfOrderDo afOrderDo = new UocAfOrderDo();
        afOrderDo.setOrderId(reqBo.getOrderId());
        afOrderDo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(afOrderDo, UocAfOrderQryBo.class);
        UocAfOrder afOrder = uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
        UocAfOrderItemQryBo uocAfOrderItemQryBo = UocRu.js(afOrderDo, UocAfOrderItemQryBo.class);
        List<UocAfOrderItem> afOrderItemList = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);

        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //修改发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            //取相反数
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            Integer servType = afOrder.getServType();
            //如果是退货服务 那么设置数量 这里就是供应商确认完成
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                uocShipOrderItem.setReturnCount(returnCount);
                uocShipOrderItem.setArriveCount(returnCount.negate());
            }
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            shipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                uocSaleOrderItem.setReturnCount(returnCount);
                uocSaleOrderItem.setArriveCount(returnCount.negate());
            }
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            saleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }

    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfterOrderFinishConfirmReqBo reqBo) {
        return uocAfOrderRepository.getAfOrderObjList(UocRu.js(reqBo,UocAfOrderObjQryBo.class));
    }
    
    @Override
    public List<UocAfOrderDo> getCheckAfOrders(UocAfOrderDo record) {
        return uocAfOrderRepository.getCheckAfOrders(UocRu.js(record,UocAfOrderDo.class));
    }

    /**
     * 修改临时验收明细售后信息执行
     * @param servState 服务单状态
     * @param uocAfOrderItemList 服务单明细集合
     */
    private void modifyInspTempAfInfoExecute(Integer servState, List<UocAfOrderItem> uocAfOrderItemList) {
        //定义销售单主体查询参数
        UocSaleOrderDo queryUocSaleOrderDo = new UocSaleOrderDo();
        //设置订单ID
        queryUocSaleOrderDo.setOrderId(uocAfOrderItemList.get(0).getOrderId());
        //设置销售单ID
        queryUocSaleOrderDo.setSaleOrderId(uocAfOrderItemList.get(0).getSaleOrderId());
        //调用查询销售单主体
        UocSaleOrderDo uocSaleOrderDo = this.saleOrderRepository.getSaleOrderMain(queryUocSaleOrderDo);

        for (UocAfOrderItem uocAfOrderItem : uocAfOrderItemList) {
            //判断服务单状态为供方标记售后完成
            if ((UocConstant.orderSource.AGR.equals(uocSaleOrderDo.getOrderSource()) || (UocConstant.orderSource.ELC.equals(uocSaleOrderDo.getOrderSource()) && !UocConstant.AREA_TYPE.EMPLOYEE_SUPERMARKET.equals(uocSaleOrderDo.getAreaType())))
                    && UocConstant.PURCHASE_MODE.PLAN.equals(uocSaleOrderDo.getPurchaseMode())
                    && UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(servState)) {

                //修改临时验收明细售后信息
                this.modifyInspTempAfInfo(uocAfOrderItem);
            }
        }
    }

    /**
     * 修改临时验收明细售后信息
     */
    private void modifyInspTempAfInfo(UocAfOrderItem uocAfOrderItem) {
        //定义查询验收单DO
        UocInspTempItemQryBo queryUocInspTempItemQryBo = new UocInspTempItemQryBo();
        //设置订单ID
        queryUocInspTempItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        //设置销售单ID
        queryUocInspTempItemQryBo.setSaleOrderId(uocAfOrderItem.getSaleOrderId());
        //设置销售明细ID
        queryUocInspTempItemQryBo.setSaleOrderItemId(uocAfOrderItem.getSaleItemId());
        //调用查询临时验收明细信息
        UocInspOrderItemTempDo uocInspOrderItemTempDo = this.uocInspOrderRepository.getInspTempItemInfo(queryUocInspTempItemQryBo);

        //判断临时验收明细信息不为空，修改临时验收明细售后信息
        if (ObjectUtil.isNotEmpty(uocInspOrderItemTempDo)) {
            //定义修改验收单DO
            UocInspOrderItemTempDo updateUocInspOrderItemTempDo = new UocInspOrderItemTempDo();
            //设置订单ID
            updateUocInspOrderItemTempDo.setOrderId(uocAfOrderItem.getOrderId());
            //设置销售单ID
            updateUocInspOrderItemTempDo.setSaleOrderId(uocAfOrderItem.getSaleOrderId());
            //设置销售明细ID
            updateUocInspOrderItemTempDo.setSaleOrderItemId(uocAfOrderItem.getSaleItemId());
            //设置退货数量
            updateUocInspOrderItemTempDo.setReturnCount(uocAfOrderItem.getReturnCount());

            //调用修改临时验收明细售后信息
            this.uocInspOrderRepository.modifyInspTempItemAfInfo(updateUocInspOrderItemTempDo);
        }

        //判断临时验收明细信息为空，新增临时验收售后处理任务
        if (ObjectUtil.isEmpty(uocInspOrderItemTempDo)) {
            //定义临时验收售后处理任务DO
            UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo = new UocInspTempAfProcessTaskDo();
            //设置订单ID
            uocInspTempAfProcessTaskDo.setOrderId(uocAfOrderItem.getOrderId());
            //设置售后服务单ID
            uocInspTempAfProcessTaskDo.setAfOrderId(uocAfOrderItem.getAfOrderId());
            //设置售后服务明细ID
            uocInspTempAfProcessTaskDo.setAfOrderItemId(uocAfOrderItem.getAfOrderItemId());
            //设置销售单ID
            uocInspTempAfProcessTaskDo.setSaleOrderId(uocAfOrderItem.getSaleOrderId());
            //设置销售明细ID
            uocInspTempAfProcessTaskDo.setSaleOrderItemId(uocAfOrderItem.getSaleItemId());
            //设置状态 处理中
            uocInspTempAfProcessTaskDo.setStatus(UocConstant.InspTempAfTaskStatus.IN_PROCESS);

            //调用新增临时验收售后处理任务
            this.uocAfOrderRepository.addInspTempAfProcessTask(uocInspTempAfProcessTaskDo);
        }
    }

    /**
     * 执行临时验收售后处理任务
     */
    @Override
    public void executeInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo) {
        //调用编辑临时验收售后处理任务，处理第一次数据
        UocInspTempAfProcessTaskQryRspPageBo taskQryRspPageBo = this.editInspTempAfProcessTask(1, 100);

        //遍历处理剩余数据
        if (ObjectUtil.isNotEmpty(taskQryRspPageBo) && ObjectUtil.isNotEmpty(taskQryRspPageBo.getTotal()) && taskQryRspPageBo.getTotal() > 1) {
            for (int i = 2; i <= taskQryRspPageBo.getTotal(); i++) {
                //调用编辑临时验收售后处理任务
                this.editInspTempAfProcessTask(i, 100);
            }
        }
    }

    /**
     * 编辑临时验收售后处理任务
     */
    private UocInspTempAfProcessTaskQryRspPageBo editInspTempAfProcessTask(Integer pageNo, Integer pageSize) {
        //定义分页查询临时验收售后处理任务参数
        UocInspTempAfProcessTaskQryReqPageBo reqPageBo = new UocInspTempAfProcessTaskQryReqPageBo();
        //设置页码
        reqPageBo.setPageNo(pageNo);
        //设置每页数量
        reqPageBo.setPageSize(pageSize);
        //设置状态 处理中
        reqPageBo.setStatus(UocConstant.InspTempAfTaskStatus.IN_PROCESS);

        //调用分页查询临时验收售后处理任务列表
        UocInspTempAfProcessTaskQryRspPageBo uocInspTempAfProcessTaskQryRspPageBo = this.uocAfOrderRepository.getInspTempAfProcessTaskPageList(reqPageBo);

        if (CollectionUtils.isEmpty(uocInspTempAfProcessTaskQryRspPageBo.getRows())) {
            return uocInspTempAfProcessTaskQryRspPageBo;
        }

        for (UocInspTempAfProcessTaskQryPageBo row : uocInspTempAfProcessTaskQryRspPageBo.getRows()) {
            //定义售后单明细查询参数
            UocAfOrderItemQryBo queryUocAfOrderItemQryBo = new UocAfOrderItemQryBo();
            //设置售后单ID
            queryUocAfOrderItemQryBo.setAfOrderId(row.getAfOrderId());
            //设置售后单明细ID
            queryUocAfOrderItemQryBo.setAfOrderItemId(row.getAfOrderItemId());

            //调用查询售后单明细
            UocAfOrderItem uocAfOrderItem = this.uocAfOrderRepository.getAfOrderItem(queryUocAfOrderItemQryBo);

            if (ObjectUtil.isNotEmpty(uocAfOrderItem)) {
                //定义修改临时验收明细售后信息DO
                UocInspOrderItemTempDo updateUocInspOrderItemTempDo = new UocInspOrderItemTempDo();
                //设置订单ID
                updateUocInspOrderItemTempDo.setOrderId(row.getOrderId());
                //设置销售单ID
                updateUocInspOrderItemTempDo.setSaleOrderId(row.getSaleOrderId());
                //设置销售明细ID
                updateUocInspOrderItemTempDo.setSaleOrderItemId(row.getSaleOrderItemId());
                //设置退货数量
                updateUocInspOrderItemTempDo.setReturnCount(uocAfOrderItem.getReturnCount());

                //调用修改临时验收明细售后信息
                this.uocInspOrderRepository.modifyInspTempItemAfInfo(updateUocInspOrderItemTempDo);


                //定义修改临时验收售后处理任务参数
                UocInspTempAfProcessTaskDo updateUocInspTempAfProcessTaskDo = new UocInspTempAfProcessTaskDo();
                //设置任务ID
                updateUocInspTempAfProcessTaskDo.setTaskId(row.getTaskId());
                //设置状态 成功
                updateUocInspTempAfProcessTaskDo.setStatus(UocConstant.InspTempAfTaskStatus.SUCCESS);

                //调用修改临时验收售后处理任务
                this.uocAfOrderRepository.updateInspTempAfProcessTask(updateUocInspTempAfProcessTaskDo);
            }
        }

        return uocInspTempAfProcessTaskQryRspPageBo;
    }
}
