package com.tydic.dyc.oc.model.implorder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplOrderItemQryBo
 * 说明:执行单明细
 * 时间:2022-02-21 19:08
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocImplOrderItemQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  6396006385972544735L;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//执行明细id")
	private Long implOrderItemId;

	//销售明细id")
	private Long saleOrderItemId;


	//明细状态")
	private String implItemState;

	//明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	//单品ID")
	private String skuId;

	//供应商ID")
	private String supplierId;

	//店铺ID")
	private String supplierShopId;

	//计量单位")
	private String unitName;

	//结算计量单位")
	private String settleUnit;

	//采购金额")
	private BigDecimal purchaseFee;

	//应付金额")
	private BigDecimal payFee;

	//运费")
	private BigDecimal transFee;

	//积分优惠金额")
	private BigDecimal integralDisFee;

	//活动优惠金额")
	private BigDecimal actDisFee;

	//其它优惠金额")
	private BigDecimal otherDisFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//币种")
	private String currencyType;

	//税金")
	private String taxPrice;

	//税率")
	private String tax;

	//税务编码")
	private String taxId;

	//采购数量")
	private BigDecimal purchaseCount;

	//发货数量")
	private BigDecimal sendCount;

	//到货数量")
	private BigDecimal arriveCount;

	//拒收数量")
	private BigDecimal refuseCount;

	//退货数量")
	private BigDecimal returnCount;

	//验收数量")
	private BigDecimal acceptanceCount;

	//售后在途数量")
	private BigDecimal afterServingCount;

	//超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

	//扩展字段")
	private String extField5;

	//采购金额")
	private BigDecimal purchasePrice;

	//采购金额")
	private BigDecimal salePrice;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//排序")
	private String orderBy;

	//执行明细idList")
	private List<Long> implOrderItemIdList;

}
