package com.tydic.dyc.oc.model.order.sub;

import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAgrBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderPlanBO;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderItem
 * 说明:销售订单明细
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderItem extends BaseExtendBo {
	private static final long serialVersionUID =  -4840136198335619491L;

	//订单明细id//
	private Long orderItemId;

	//订单id//
	private Long orderId;

	//明细类型             1 商品sku             2 物资             3 项目//
	private Integer itemType;

	//明细状态//
	private String orderItemState;

	//商品id//
	private String commodityId;

	//商品名称//
	private String commodityName;

	//商品类型ID//
	private String commodityTypeId;

	//商品类型名称//
	private String commodityTypeName;

	//外部单品ID//
	private String extSkuId;

	//单品ID//
	private String skuId;

	//单品编码//
	private String skuCode;

	//单品名称//
	private String skuName;

	//供应商ID//
	private String supplierId;

	//供应商名称//
	private String supplierName;

	//供应商联系人//
	private String supRelaName;

	//供应商联系电话//
	private String supRelaMobile;

	//店铺ID//
	private String supplierShopId;

	//店铺名称//
	private String supplierShopName;

	//销售金额//
	private BigDecimal saleFee;

	//采购金额//
	private BigDecimal purchaseFee;

	//单品来源      1 自营单品   2 电商导入   3 协议生成    //
	private Integer skuSource;

	//采购金额//
	private BigDecimal purchasePrice;

	//采购金额//
	private BigDecimal salePrice;

	//采购数量//
	private BigDecimal purchaseCount;

	//运费//
	private BigDecimal transFee;

	//应付金额//
	private BigDecimal payFee;

	//积分优惠金额//
	private BigDecimal integralDisFee;

	//活动优惠金额//
	private BigDecimal actDisFee;

	//其它优惠金额//
	private BigDecimal otherDisFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//币种")
	private String currencyType;

	//税金")
	private String taxPrice;

	//税率")
	private String tax;

	//预计发货时间")
	private Date preSendTime;

	//预计交货时间")
	private Date preOfferTime;

	//计量单位")
	private String unitName;

	//结算计量单位")
	private String settleUnit;

	//外部电商主订单id")
	private String imOrderId;

	//外部电商子订单id")
	private String imSubOrderId;

	//到货周期")
	private String arrivalTime;

	//加价率")
	private Double markUpRate;

	//商品服务费 ")
	private String serPrice;

	//计划id")
	private String planId;

	//计划明细id")
	private String planItemId;

	//计划编号")
	private String planNo;

	//计划明细编号")
	private String planItemNo;
	/**
	 * 计划来源1SAP;2电商平台
	 */
	private Integer planSource;
	/**
	 * 计划单位
	 */
	private String planUnit;
	/**
	 * 单位转换倍率
	 */
	private BigDecimal planConversionRate;

	//超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	//税务编码")
	private String taxId;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//协议经办人id（配送专责），协议商品必传")
	private String proDeliveryId;

	//协议经办人名字（配送专责），协议商品必传")
	private String proDeliveryName;

	//协议id")
	private String agreementId;

	//协议编号")
	private String agreementNo;

	//协议明细编号")
	private String agreementIdItemNo;

	//协议bo，协议商品必传（根据协议id是否为空来判断）")
	private UocOrderAgreement agrBo;

	//sku物料id")
	private String skuMaterialId;

	//sku物料编码")
	private String skuMaterialCode;

	//sku外部单品id")
	private String skuExtSkuId;

	//sku品牌id")
	private Long skuBrandId;

	//单品品牌名称")
	private String skuBrandName;

	//sku明细id")
	private String skuItemId;

	//sku物料名称")
	private String skuMaterialName;

	//sku物料类型名称")
	private String skuMaterialTypeName;

	//sku物料类型id")
	private String skuMaterialTypeId;

	//型号")
	private String model;

	//规格")
	private String spec;

	//材质")
	private String texture;

	//图号")
	private String figure;

	//一级类目")
	private Long l1catalog;

	//二级类目")
	private Long l2catalog;

	//三级类目")
	private Long l3catalog;

	//一级类目名称")
	private String l1catalogName;

	//二级类目名称")
	private String l2catalogName;

	//三级类目名称")
	private String l3catalogName;

	//退货时间，空代表不支持")
	private Integer rejectAllowDate;

	//换货时间，空代表不支持")
	private Integer exchangeAllowDate;

	//维修时间，空代表不支持")
	private Integer maintainAllowDate;

	//sku单品主图url")
	private String skuMainPicUrl;


	//商品json字符串，商品查询回原样数据，订单保存，以备未来使用")
	private String commJsonStr;


	//订单明细扩展")
	private List<UocOrderItemMap> itemMapList;
    
    
    //销售单明细扩展")
    private List<UocSaleItemMap> saleItemMapList;
    
    
	//订单明细-商品-扩展")
	private List<UocOrderItemSnapshotMap> commSnapshotExtList;

	//订单延保信息")
	private List<UocOrderItemEw> ewList;
    
    //商品编码
    //商品编码")
    private String commodityCode;
    
    //比选单号")
    private String cmpOrderNo;
    
    //未比选原因")
    private String noCmpReason;

    //供货周期")
	private String deliveryTimeDate;

	//计量单位位数")
	private String unitDigit;
    
    /**
     * 商品支持售后返回方式
     */
    private List<Integer> serverReturnTypeList;
    
    //商品关联计划明细列表
    private List<UocOrderPlanBO> orderPlanBOList;

	/**
	 * 铺货单位ID
	 */
	private String managementOrgId;
	/**
	 * 铺货单位名称
	 */
	private String managementOrgName;
	/**
	 * 协议价格明细执行时间
	 */
	private Date agrItemActiveTime;
	/**
	 * 协议价格明细创建时间
	 */
	private Date agrItemCreateTime;
	/**
	 * 协议价格明细不含税单价
	 */
	private BigDecimal agrItemNoTaxPrice;
	/**
	 * 订单附件信息
	 */
	private List<UocOrderAccessory> attachBos;

}
