package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.service.common.bo.UocProRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapSendOrderLog;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 标题:IUocSaleOrderModelImpl
 * 说明:销售单领域方法服务实现
 * 时间:2022/2/24 18:27
 * 作者:田桂银
 */
@Service
@Slf4j
public class UocSaleOrderModelImpl implements IUocSaleOrderModel {

    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;

    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Autowired
    private UocAgreementOrderRepository uocAgreementOrderRepository;

    @Autowired
    private UocOrderRepository uocOrderRepository;


    @Value("${isLimitPrice:true}")
    private boolean limitPrice;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        validateCreateArg(saleOrderDo);
        if (ObjectUtil.isEmpty(saleOrderDo.getSaleOrderNo())) {
            saleOrderDo.setSaleOrderNo(genRequestCode(saleOrderDo));
        }
        //设置销售单
        if (ObjectUtil.isEmpty(saleOrderDo.getSaleOrderId())) {
            saleOrderDo.setSaleOrderId(IdUtil.nextId());
        }
        //为空，创建一个，不为空沿用（京东拆单）
        if (null == saleOrderDo.getCreateTime()) {
            saleOrderDo.setCreateTime(new Date());
        }
        //默认设置为刚创建状态
        if (ObjectUtil.isEmpty(saleOrderDo.getSaleOrderState())) {
            saleOrderDo.setSaleOrderState(null);
        }
        //设置采购模式(默认非计划)
//        if (ObjectUtil.isNotEmpty(saleOrderDo.getSaleOrderItems().get(0).getPlanId())) {
//            saleOrderDo.setPurchaseMode(UocDicConstant.PURCHASE_MODE.PLAN);
//        }

        //设置合同编号
        if (null != saleOrderDo.getSaleOrderItems().get(0).getAgrBo()) {
            saleOrderDo.setContractNo(saleOrderDo.getSaleOrderItems().get(0).getAgrBo().getContractNo());
        }
        //设置销售单扩展
        List<UocSaleOrderMap> saleOrderMapList = saleOrderDo.getSaleOrderMapList();
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {

            Map<String, UocSaleOrderMap> baseExtendFieldBoMap = saleOrderMapList.stream().
                    collect(Collectors.toMap(UocSaleOrderMap::getFieldCode, e -> e));

            if (ObjectUtil.isNotEmpty(baseExtendFieldBoMap.get("budgetModelCode")) && "3".equals(baseExtendFieldBoMap.get("budgetModelCode").getFieldValue())
                    && UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
                saleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QR_DQR);
            }

            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setOrderId(saleOrderDo.getOrderId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }

        //设置支付配置
        List<UocSaleOrderPayConf> saleOrderPayConfList = saleOrderDo.getSaleOrderPayConfList();
        Integer modelSettle = saleOrderDo.getModelSettle();
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
            for (UocSaleOrderPayConf payConf : saleOrderPayConfList) {
                payConf.setId(IdUtil.nextId());
                payConf.setOrderId(saleOrderDo.getOrderId());
                payConf.setCreateTime(saleOrderDo.getCreateTime());
                payConf.setCreateOperId(saleOrderDo.getCreateOperId());
                payConf.setSaleOrderId(saleOrderDo.getSaleOrderId());
                //结算模式为 1:贸易模式
                //if (UocDicConstant.MODEL_SETTLE.TRADE.equals(modelSettle) && UocDicConstant.PAY_CONF_USE_TYPE.PRO.equals(payConf.getUserType())){
                //    saleOrderDo.setPayType(payConf.getPayType() != null ? payConf.getPayType().toString() : null);
                //}
                //结算模式为 2:撮合模式
                if (UocDicConstant.PAY_CONF_USE_TYPE.PUR.equals(payConf.getUserType())) {
                    saleOrderDo.setPayType(payConf.getPayType() != null ? payConf.getPayType().toString() : null);
                }
            }
        }

        //设置附件
        List<UocOrderAccessory> saleOrderAccessoryList = saleOrderDo.getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            for (UocOrderAccessory accessory : saleOrderAccessoryList) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }

        //设置销售明细
        setSaleItems(saleOrderDo);
        //设置商品对应售后方式表
        setAfterTakeType(saleOrderDo);

        //限额
        if (limitPrice && !saleOrderDo.getSplitCreateOrder()) {
            BigDecimal totalSale = saleOrderDo.getTotalSaleFee();
            totalSale = totalSale.multiply(new BigDecimal(10000));
            String supNo = saleOrderDo.getStakeholder().getSupId();
            String supName = saleOrderDo.getStakeholder().getSupName();
            log.info("供应商 {}，下单金额为 {}", supNo, totalSale);
            UocConfSupplier uocConfSupplier = new UocConfSupplier();
            uocConfSupplier.setSupNo(Long.valueOf(supNo));
            uocConfSupplier.setLimitStatus(0);
            uocConfSupplier = uocOrderRepository.getConfSupplierModelBy(uocConfSupplier);
            //查询全部
            UocConfSupplier uocConfSupplier1 = new UocConfSupplier();
            uocConfSupplier1.setSupNo(0L);
            uocConfSupplier1.setLimitStatus(0);
            uocConfSupplier1.setBusinessTypeCode(String.valueOf(saleOrderDo.getOrderSource()));
            uocConfSupplier1 = uocOrderRepository.getConfSupplierModelBy(uocConfSupplier1);

            uocConfSupplier = Objects.nonNull(uocConfSupplier) ? uocConfSupplier : uocConfSupplier1;

            if (ObjectUtil.isNotEmpty(uocConfSupplier)) {
                Long limit = uocConfSupplier.getOrderLimit();

                log.info("订单限额：{}", limit);
                //如果该供应商配置了订单最高限额，且大于0，则需要判断当前下单金额是否满足

                if (limit != null && limit > 0) {
                    if (limit > totalSale.longValue()) {
                        String money = null;
                        try {
                            money = UocMoneyUtil.long2BigDecimal(limit).toString();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ORDER_MONEY_CHECK_ERROR, supName + "下的订单不满足" + money + "元，不允许下单。");
                    }
                }

            }
        }


        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
            //协议，设置铺货单位
            if (ObjectUtil.isNotEmpty(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgId())) {
                saleOrderDo.setManagementOrgId(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgId());
                saleOrderDo.setManagementOrgName(saleOrderDo.getSaleOrderItems().get(0).getManagementOrgName());
            }
        } else {
            //非协议，设置铺货单位为三方表的供应商id
            UocSaleStakeholderQryBo qryStakeHolder = new UocSaleStakeholderQryBo();
            qryStakeHolder.setStakeholderId(saleOrderDo.getStakeholderId());
            UocSaleStakeholder saleOrderStakeholder = uocSaleOrderRepository.getSaleOrderStakeholder(qryStakeHolder);
            if (ObjectUtil.isNotEmpty(saleOrderStakeholder)) {
                saleOrderDo.setManagementOrgId(saleOrderStakeholder.getSupId());
                saleOrderDo.setManagementOrgName(saleOrderStakeholder.getSupName());
            }
        }

        return uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if (ObjectUtil.isEmpty(saleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            saleOrderItem.setBargainingId(saleOrderDo.getBargainingId());
            saleOrderItem.setBargainingNo(saleOrderDo.getBargainingNo());
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            if (ObjectUtil.isEmpty(saleOrderItem.getSaleOrderItemId())) {
                saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            }
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            saleOrderItem.setPurchaseFee(saleOrderItem.getPurchasePrice().multiply(saleOrderItem.getPurchaseCount()));
            saleOrderItem.setSaleFee(saleOrderItem.getSalePrice().multiply(saleOrderItem.getPurchaseCount()));
            //如果外部传入比选单号为空或者空串，直接置为null，避免摸棱两可的情况导致其它bug
            if (ObjectUtil.isEmpty(saleOrderItem.getCmpOrderNo())) {
                saleOrderItem.setCmpOrderNo(null);
            }

            //设置附件
            List<UocOrderAccessory> saleOrderAccessoryList = saleOrderItem.getAttachBos();
            if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
                for (UocOrderAccessory accessory : saleOrderAccessoryList) {
                    accessory.setId(IdUtil.nextId());
                    accessory.setObjId(saleOrderItem.getSaleOrderItemId());
                    accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE_ITEM);
                    accessory.setOrderId(saleOrderDo.getOrderId());
                    accessory.setCreateTime(saleOrderDo.getCreateTime());
                    accessory.setCreateOperId(saleOrderDo.getCreateOperId());
                    accessory.setAttachmentType(UocAttachementTypeConstants.AGR_ITEM_WEIGHT);
                }
            }

            List<UocSaleItemMap> saleItemMapList = saleOrderItem.getSaleItemMapList();
            if (ObjectUtil.isNotEmpty(saleItemMapList)) {
                for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                    uocSaleItemMap.setId(IdUtil.nextId());
                    uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                    uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                    uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                    uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
                }
            }
            //协议、无协议保存超验百分比
            if (!saleOrderItem.getSkuSource().equals(UocConstant.SkuSource.ELC)) {
                UocConfInspection uocConfInspection = new UocConfInspection();
                Integer inspectionType = null;
                Integer busiType = null;
                if (saleOrderItem.getSkuSource().equals(UocConstant.SkuSource.SELF)) {
                    UocConfInspectionUse uocConfInspectionUse = new UocConfInspectionUse();
                    uocConfInspectionUse.setBusiType(3);
                    List<UocConfInspectionUse> uocConfInspectionUses = uocOrderRepository.qryInspectionConfigUseList(uocConfInspectionUse);
                    if (!CollectionUtils.isEmpty(uocConfInspectionUses)) {
                        inspectionType = uocConfInspectionUses.get(0).getInspectionType();
                        busiType = 3;
                    }
                } else if (saleOrderItem.getSkuSource().equals(UocConstant.SkuSource.AGR)) {
                    UocConfInspectionUse uocConfInspectionUse = new UocConfInspectionUse();
                    uocConfInspectionUse.setBusiType(1);
                    List<UocConfInspectionUse> uocConfInspectionUses = uocOrderRepository.qryInspectionConfigUseList(uocConfInspectionUse);
                    if (!CollectionUtils.isEmpty(uocConfInspectionUses)) {
                        inspectionType = uocConfInspectionUses.get(0).getInspectionType();
                        busiType = 1;
                    }
                }
                if (busiType != null && inspectionType != null) {
                    uocConfInspection.setBusiType(busiType);
                    uocConfInspection.setInspectionType(inspectionType);
                    List<UocConfInspection> uocConfInspections = uocOrderRepository.qryInspectionConfigList(uocConfInspection);
                    if (!CollectionUtils.isEmpty(uocConfInspections)) {
                        if (uocConfInspections.get(0).getInspectionType().equals(UocConstant.INSPECTION_TYPE_ALL)) {
                            saleOrderItem.setInspectionExcessPercent(uocConfInspections.get(0).getExcessPercent());
                        } else {
                            Map<String, List<UocConfInspection>> commodityTypeMap = uocConfInspections.stream().collect(Collectors.groupingBy(UocConfInspection::getCommodityType));
                            saleOrderItem.setInspectionExcessPercent(commodityTypeMap.get(saleOrderItem.getCommodityTypeId()) == null ? 0 : commodityTypeMap.get(saleOrderItem.getCommodityTypeId()).get(0).getExcessPercent());
                        }
                    }
                }
            }

        }
    }

    private void setAfterTakeType(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            List<Integer> returnTypeList = saleOrderItem.getServerReturnTypeList();
            if (ObjectUtil.isNotEmpty(returnTypeList)) {
                returnTypeList.forEach(e -> {
                    UocSaleGoodsAfterTakeTypeBo afterTakeTypeBo = new UocSaleGoodsAfterTakeTypeBo();
                    afterTakeTypeBo.setAfterTakeType(e);
                    afterTakeTypeBo.setAfterTakeId(IdUtil.nextId());
                    afterTakeTypeBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    afterTakeTypeBo.setCommodityId(saleOrderItem.getCommodityId());
                    uocSaleOrderRepository.insertCommityAfterTakeType(afterTakeTypeBo);
                });
            }
        }
    }


    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "销售单明细id集合不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemListByItemIds(itemIds);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }


    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        /*if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }*/
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }

        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        validateUpdateSaleOrderArg(reqBo);
        //查询销售单修改前状态
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty(uocSaleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_UPDATE_STATE_ERROR, "该销售单" + reqBo.getSaleOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);

        //更新销售单数据
        return uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocUpdateSaleOrderStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUpdateOperId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【更新人id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单状态】不能为空");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        return uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }

    /**
     * 查询销售单三方信息（单条）
     *
     * @param qryBo
     * @return
     */
    @Override
    public UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.getSaleOrderStakeholder(qryBo);
    }


    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        if (UocConstant.orderSource.ELC.equals(saleOrderDo.getOrderSource()) && UocConstant.AREA_TYPE.EMPLOYEE_SUPERMARKET.equals(saleOrderDo.getAreaType())) {
            return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.SALE_ORDER_NO + "_4");
        }
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.SALE_ORDER_NO + "_" + saleOrderDo.getOrderSource());
    }

    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.addSaleOrderMap(uocSaleOrderDo);
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.updateBatchValue(uocSaleOrderDo);
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.updateInvalid(uocSaleOrderDo);
    }

    @Override
    public UocOrderAgreement getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull(uocOrderAgreementQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAgreementOrderRepository.getAgreementOrderBy(uocOrderAgreementQryBo);
    }

    @Override
    public List<UocOrderAgreement> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull(uocOrderAgreementQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAgreementOrderRepository.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    @Override
    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (ObjectUtil.isNull(uocSaleOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocSaleOrderRepository.qryTotalFeeAndCount(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (ObjectUtil.isNull(uocSaleOrderItemQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocSaleOrderRepository.getListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细列表不能为空");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getSendCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参发货数量不能为空");
            }
        });
        uocSaleOrderRepository.modifyBatchItemSendCount(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo) {
        valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细列表不能为空");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getArrivalTime()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参到货周期不能为空");
            }
        });
        uocSaleOrderRepository.modifyBatchItemArrivalTime(convertSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo getCollectCountImplOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaleOrderItemQryBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        return uocSaleOrderRepository.getCollectCount(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细列表不能为空");
        }
        uocSaleOrderDo.getSaleOrderItems().forEach(uocSaleOrderItem -> {
            if (null == uocSaleOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细ID不能为空");
            }
            if (null == uocSaleOrderItem.getAcceptanceCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参验收数量不能为空");
            }
        });
        uocSaleOrderRepository.modifyBatchItemInspCount(uocSaleOrderDo);

    }

    @Override
    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo.getStakeholder()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参三方信息不能为空");
        }
        if (uocSaleOrderDo.getStakeholder().getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参订单ID不能为空");
        }
        uocSaleOrderRepository.modifySaleOrderStakeholder(uocSaleOrderDo);
    }

    @Override
    public void modifySalePrice(UocSaleOrderDo uocSaleOrderDo) {
        // 修改销售单明细销售金额
        uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
        // 统计销售单明细销售价总金额
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        // 更新销售单销售金额
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);

    }

    @Override
    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        valSaleItem(uocSaleOrderItem);
        uocSaleOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    @Override
    public void modifyBatchItemChngingCount(UocSaleOrderDo convertImplOrderDo) {
        uocSaleOrderRepository.modifyBatchItemChngingCount(convertImplOrderDo);
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单id不能为空");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参销售单id不能为空");
        }
        uocSaleOrderRepository.modifyBatchItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        //if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
        //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单id不能为空");
        //}
        //if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
        //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参销售单id不能为空");
        //}
        uocSaleOrderRepository.modifyBatchItemReturnCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    @Override
    public void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.batchModifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    private void valSaleItem(UocSaleOrderItem uocSaleOrderItem) {
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(uocSaleOrderItem.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (ObjectUtil.isEmpty(uocSaleOrderItem.getSaleOrderItemId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单明细ID不能为空");
        }

    }

    private void valDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }

    }

    @Override
    public void deleteSaleOrder(UocSaleOrderDo saleOrderDo) {
        //入参校验
        deleteSaleOrderValDo(saleOrderDo);
        //修改标志位
        uocSaleOrderRepository.deleteSaleOrder(saleOrderDo);

    }

    @Override
    public void updateProcInst(UocOrderProcInst uocOrderProcInst) {
        uocCommonRepository.updateProInst(uocOrderProcInst);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        uocCommonRepository.updateTaskInst(uocOrderTaskInst);
    }

    private void deleteSaleOrderValDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
    }

    @Override
    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        uocSaleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    @Override
    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifyInspSuper(uocSaleOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifyItemRefuseCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifyItemArriveCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        validateUpdateSaleItemWithOutSkuId(uocSaleOrderDo);
        uocSaleOrderRepository.updateItem(uocSaleOrderDo);

    }

    @Override
    public void updateSaleItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.updateItemArriveAccount(uocSaleOrderDo);
    }

    @Override
    public void modifyPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        // 修改销售单明细采购金额
        uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
        // 统计销售单明细采购价总金额
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        // 更新销售单采购金额
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    private void validateUpdateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(uocSaleOrderDo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if (ObjectUtil.isEmpty(uocSaleOrderDo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单id]不能为空");
        }
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (ObjectUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[saleOrderItems]不能为空");
        }
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (saleOrderItem == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[saleOrderItem]不能为空");
            }
            if (ObjectUtil.isEmpty(saleOrderItem.getSaleOrderId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SaleOrderId]不能为空");
            }
            if (ObjectUtil.isEmpty(saleOrderItem.getOrderId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SaleOrderId]不能为空");
            }
            if (ObjectUtil.isEmpty(saleOrderItem.getSkuExtSkuId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SkuExtSkuId]不能为空");
            }
            if (ObjectUtil.isEmpty(saleOrderItem.getNakedPrice())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[NakedPrice]不能为空");
            }
            if (ObjectUtil.isEmpty(saleOrderItem.getTax())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[Tax]不能为空");
            }
            if (ObjectUtil.isEmpty(saleOrderItem.getTaxPrice())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[TaxPrice]不能为空");
            }
        }


    }

    @Override
    public void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        uocSaleOrderRepository.modifyItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        uocSaleOrderRepository.modifyItemChngCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmAdd(UocSaleOrderDo convertSaleOrderDo) {
        uocSaleOrderRepository.modifyItemChngCountConfirmAdd(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmReduce(UocSaleOrderDo convertSaleOrderDo) {
        uocSaleOrderRepository.modifyItemChngCountConfirmReduce(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return uocSaleOrderRepository.getSaleOrderList(uocSaleOrderQryBo);
    }

    @Override
    public List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo convertSaleOrderDo) {
        return uocSaleOrderRepository.cancelEsOrderList(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return uocSaleOrderRepository.getSaleOrders(uocSaleOrderQryBo);
    }

    @Override
    public Integer qrySaleCounts(UocSaleOrderDo uocSaleOrderDo) {
        return uocSaleOrderRepository.qrySaleOrderCounts(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleGoodsAfterTakeTypeBo> qryCommityTakeTypes(UocSaleGoodsAfterTakeTypeBo takeTypeBo) {
        return uocSaleOrderRepository.qryCommityTakeTypes(takeTypeBo);
    }

    @Override
    public List<UocSaleOrderItemPlan> selectSaleOrderItemPlan(UocSaleOrderItemPlanBo record) {
        return uocSaleOrderRepository.selectSaleOrderItemPlan(record);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderListByBar(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return uocSaleOrderRepository.getSaleOrderListByBar(uocSaleOrderQryBo);
    }

    @Override
    public void batchSyncSale() {
        uocSaleOrderRepository.batchSyncSale();
    }

    @Override
    public void modifyItemPlan(UocSaleOrderItem saleOrderItem) {
        uocSaleOrderRepository.modifyItemPlan(saleOrderItem);
    }

    @Override
    public void insertSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo) {
        this.uocSaleOrderRepository.insertSapSendInfo(uocSapOrderSendInfo);
    }

    @Override
    public void updateSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo) {
        this.uocSaleOrderRepository.updateSapSendInfo(uocSapOrderSendInfo);
    }

    @Override
    public List<UocSapOrderSendInfo> getSapSendInfoList(UocSapOrderSendInfo uocSapOrderSendInfo) {
        return this.uocSaleOrderRepository.getSapSendInfoList(uocSapOrderSendInfo);
    }

    @Override
    public BasePageRspBo<UocSapSendOrderLog> getSapSendInfoListPage(UocQrySapSendOrderLogReqBO uocQrySapSendOrderLogReqBO) {
        return this.uocSaleOrderRepository.getSapSendInfoListPage(uocQrySapSendOrderLogReqBO);
    }

    @Override
    public BasePageRspBo<UocInspOrderTemporarily> selectTempInspOrderListPage(UocQryTempInspListReqBO uocQryTempInspListReqBO) {
        return this.uocSaleOrderRepository.selectTempInspOrderListPage(uocQryTempInspListReqBO);
    }

    @Override
    public int insertSapArrivalInspBatch(List<UocSapArrivalInspInfo> list) {
        return this.uocSaleOrderRepository.insertSapArrivalInspBatch(list);
    }

    @Override
    public List<UocInspOrderTemporarily> selectTempInspOrderList(UocInspOrderTemporarily uocInspOrderTemporarily) {
        return this.uocSaleOrderRepository.selectTempInspOrderList(uocInspOrderTemporarily);
    }

    @Override
    public void updateTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily) {
        this.uocSaleOrderRepository.updateTempInspOrder(uocInspOrderTemporarily);
    }

    @Override
    public void insertTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily) {
        this.uocSaleOrderRepository.insertTempInspOrder(uocInspOrderTemporarily);
    }

    @Override
    public List<UocInspOrderItemTemporarily> selectTempInspOrderItemList(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        return this.uocSaleOrderRepository.selectTempInspOrderItemList(uocInspOrderItemTemporarily);
    }

    @Override
    public void updateTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        this.uocSaleOrderRepository.updateTempInspOrderItem(uocInspOrderItemTemporarily);
    }

    @Override
    public void insertTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        this.uocSaleOrderRepository.updateTempInspOrderItem(uocInspOrderItemTemporarily);
    }

    @Override
    public List<SapArrivalInspInfo> qrySapArrivalInspInfoList(UocSapArrivalInspInfo sapArrivalInspInfo) {
        return this.uocSaleOrderRepository.qrySapArrivalInspInfoList(sapArrivalInspInfo);
    }

    @Override
    public List<String> getMaterialBySkuId(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return this.uocSaleOrderRepository.getMaterialBySkuId(uocSaleOrderQryBo);
    }

    /**
     * 申请开票
     */
    @Override
    public void dealApplyDealInvoice(UocSaleOrderDo uocSaleOrderDo) {
        //修改销售单发票信息
        this.uocSaleOrderRepository.updateDealInvoiceInfo(uocSaleOrderDo);
    }

    /**
     * 驳回开票
     */
    @Override
    public void dealRejectDealInvoice(UocSaleOrderDo uocSaleOrderDo) {
        //修改销售单发票信息
        this.uocSaleOrderRepository.updateDealInvoiceInfo(uocSaleOrderDo);
    }

    /**
     * 完成全部开票
     */
    @Override
    public void dealCompleteAllDealInvoice(UocSaleOrderDo uocSaleOrderDo) {
        //修改销售单发票信息
        this.uocSaleOrderRepository.updateDealInvoiceInfo(uocSaleOrderDo);
    }

    @Override
    public List<UocTransactionPrice> qryTransactionPrice(UocTransactionPrice reqBO) {
        return this.uocSaleOrderRepository.qryTransactionPrice(reqBO);
    }
}


