package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocThirdApiCommonConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealMsgReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealMsgRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

import java.util.ArrayList;
import java.util.List;

/*
 * @Author lsl
 * @Description //TODO 售后单处理方法，用于消息处理
 * @Date 16:56 2022/4/11
 * @Param
 * @return
 */
@HTServiceImpl
public class UocDealMsgServiceImpl implements UocDealMsgService{
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private Environment environment;
    
    @Override
    public UocDealMsgRspBo dealMsg(UocDealMsgReqBo reqBo) {
        UocDealMsgRspBo rspBo = new UocDealMsgRspBo();
        UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
        uocDMsgPoolQryBo.setMsgId(reqBo.getMsgId());
        uocDMsgPoolQryBo = iUocOrderModel.getModelByMsgId(uocDMsgPoolQryBo);
        
        
        generalShipTable(uocDMsgPoolQryBo);
        return rspBo;
    }
    /*
     * @Author lsl
     * @Description //生成发货单
     * @Date 17:05 2022/4/11
     * @Param [uocDMsgPoolQryBo]
     * @return void
     */
    public void generalShipTable(UocDMsgPoolQryBo uocDMsgPoolQryBo){
        validataArg(uocDMsgPoolQryBo);
    
        if (environment.getProperty(UocThirdApiCommonConstant.SUPPLIER_JD_ID_KEY).equals(String.valueOf(uocDMsgPoolQryBo.getSupNo()))
                || environment.getProperty(UocThirdApiCommonConstant.SUPPLIER_SUNING_ID_KEY).equals(String.valueOf(uocDMsgPoolQryBo.getSupNo()))) {
            if (StringUtils.isBlank(uocDMsgPoolQryBo.getPackageId())) {
                uocDMsgPoolQryBo.setPackageId(uocDMsgPoolQryBo.getOutOrderId());
            }
        }
        //检验销售单状态
        List<UocOrderQueryIndex> uocOrderQueryIndexList = getOrderQueryIndex(uocDMsgPoolQryBo);
        if (uocOrderQueryIndexList == null ) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "订单发货通知业务失败：未查询到外部订单[" +
                    uocDMsgPoolQryBo.getOutOrderId() + "]所对应的内部订单信息!");
        }
        //查询销售订单信息，并判断销售订单状态是否为待发货
        UocSaleOrderDo uocSaleOrderDo = qrySale(uocDMsgPoolQryBo.getOrderId());
        String currentSaleOrderState = uocSaleOrderDo.getSaleOrderState();//订单状态
        //生成发货单
        

    }
    /*
     * @Author lsl
     * @Description //TODO 入参非空校验
     * @Date 17:12 2022/4/11
     * @Param [uocDMsgPoolQryBo]
     * @return void
     */
    public void validataArg(UocDMsgPoolQryBo uocDMsgPoolQryBo){
        if (StringUtils.isEmpty(uocDMsgPoolQryBo.getOutOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
    
        if (StringUtils.isEmpty(uocDMsgPoolQryBo.getPackageId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单发货通知业务失败：外部发货单编号[packageId]不能为空");
        }
        if (ObjectUtil.isEmpty(uocDMsgPoolQryBo.getSupNo())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单发货通知业务失败：供应商编号[supNo]不能为空");
        }
    }
    /*
     * @Author lsl
     * @Description //TODO 查询内外订单关联关系信息
     * @Date 17:33 2022/4/11
     * @Param [uocDMsgPoolQryBo]
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex>
     */
    public List<UocOrderQueryIndex> getOrderQueryIndex(UocDMsgPoolQryBo uocDMsgPoolQryBo){
        List<UocOrderQueryIndex> rspBO = new ArrayList<>();
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setOrderSystem("2");
        qryBo.setOutObjId(uocDMsgPoolQryBo.getOutOrderId());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(qryBo);
        return uocOrderQueryIndexList;
    }
    /*
     * @Author lsl
     * @Description //TODO 查询销售单订单消息
     * @Date 17:33 2022/4/11
     * @Param [orderId]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(Long orderId){
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        return uocSaleOrderDo;
    }
}
