package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspInspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspSaleOrderBo;
import com.tydic.dyc.oc.transactionservice.UocUpdateInspPayStatusTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocUpdateInspPayStatusServiceImpl
 * 说明:
 * 时间:2023/9/26 11:01
 * 作者:田桂银
 */
@HTServiceImpl
@Slf4j
public class UocUpdateInspPayStatusServiceImpl implements UocUpdateInspPayStatusService {
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocUpdateInspPayStatusTransaction uocUpdateInspPayStatusTransaction;


    @Override
    public UocUpdateInspPayStatusServiceRspBo updateInspPayStatus(UocUpdateInspPayStatusServiceReqBo reqBo) {
        UocUpdateInspPayStatusServiceRspBo rspBo = uocUpdateInspPayStatusTransaction.updateInspPayStatus(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocUpdateInspPayStatusServiceReqBo reqBo, UocUpdateInspPayStatusServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        List<UocUpdateInspPayStatusServiceRspSaleOrderBo> needCompletionSaleOrderList = rspBo.getNeedCompletionSaleOrderList();
        if (ObjectUtil.isNotEmpty(needCompletionSaleOrderList)) {
            for (UocUpdateInspPayStatusServiceRspSaleOrderBo saleOrderBo : needCompletionSaleOrderList) {
                SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
                orderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
                orderBo.setOrderId(saleOrderBo.getOrderId());
                orderBo.setObjId(saleOrderBo.getSaleOrderId());
                orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(orderBo);
            }
        }
        List<UocUpdateInspPayStatusServiceRspInspBo> inspOrderList = rspBo.getInspList();
        if (ObjectUtil.isNotEmpty(inspOrderList)) {
            for (UocUpdateInspPayStatusServiceRspInspBo inspBo : inspOrderList) {
                SyncEsRunnableBo syncInspBo = new SyncEsRunnableBo();
                syncInspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
                syncInspBo.setOrderId(inspBo.getOrderId());
                syncInspBo.setObjId(inspBo.getInspOrderId());
                syncInspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(syncInspBo);
            }
        }
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));

    }
}


