package com.tydic.dyc.oc.model.saleorder;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapSendOrderLog;

import java.util.List;


/**
 * 标题:IUocSaleOrderModel
 * 说明:销售单领域方法服务
 * 时间:2022/2/24 18:05
 * 作者:田桂银
 */
public interface IUocSaleOrderModel {

    /**
     * 描述:创建销售单
     * @param saleOrderDo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tgy
     * @date 2022/2/24 18:26
     */
    UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo);

    /**
     * 描述:查询销售单主体
     *
     * @param uocSaleOrderQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tkl
     * @date 2022/2/25 10:35
     */
    UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo);

    /**
     * 描述:查询销售单附件
     *
     * @param uocOrderAccessoryQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tkl
     * @date 2022/2/25 10:35
     */
    UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo);

    /**
     * 描述:查询销售单支付配置
     *
     * @param uocSaleOrderPayConfQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo);

    /**
     * 描述:查询销售单扩展
     * @param uocSaleOrderMapQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo);

    /**
     * 描述:查询销售单明细
     * @param uocSaleOrderItemQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);


    BasePageRspBo<UocGetSaleOrderItemsServiceRspItemBo> getSaleOrderItemListPage(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 描述:根据销售单明细id集合查询销售单明细
     * @param itemIds 销售单明细id集合
     * @return 销售单明细
     */
    List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds);

    /**
     * 描述:查询销售单明细扩展
     * @param uocSaleItemMapQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo);

    /**
     * 销售明细查询
     * @param uocSaleOrderItemQryBo
     * @return
     */
    UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 更新销售单主体信息
     *
     * @param uocSaleOrderDo
     */
    void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 描述:更新销售单状态和环节编码
     * @param saleOrderDo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tgy
     * @date 2022/2/27 9:17
     */
    UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo saleOrderDo);

    /**
     * 描述:更新流程任务到已完结
     * @param uocOrderTaskInstList 入参
     * @return void
     * @author tgy
     * @date 2022/2/27 12:47
     */
    void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList);

    /**
     * 描述:保存流程任务实例数据
     * @param saveTaskList 入参
     * @return void
     * @author tgy
     * @date 2022/2/27 12:47
     */
    void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList);


    /**
     * 描述:查询销售单列表
     * @param qryDo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo>
     * @author tgy
     * @date 2022/2/27 15:07
     */
    List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo);

    /**
     * 描述:创建流程实例数据
     * @param inst 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/2/27 21:33
     */
    UocOrderProcInst createProInst(UocOrderProcInst inst);

    /**
     * 描述:任务实例列表查询
     * @param inst 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderProcInst>
     * @author tgy
     * @date 2022/2/27 22:02
     */
    List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst);


    /**
     * 描述:任务列表查询
     * @param taskInst 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst>
     * @author tgy
     * @date 2022/3/9 13:21
     */
    List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst);

    /**
     * 描述:保存任务处理对象数据
     * @param dealList 入参
     * @return void
     * @author tgy
     * @date 2022/3/1 18:24
     */
    void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList);

    /**
     * 查询销售的主体
     * @param uocSaleOrderDo
     * @return
     */
    UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 查询销售单三方信息（多条）
     *
     * @param qryBo
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder></>
     */
    List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo);

    /**
     * 查询销售单三方信息（单条）
     * @param qryBo
     * @return
     */
    UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo);
    /**
     * 增加扩展字段
     *
     * @param uocSaleOrderDo
     */
    void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 批量更新扩展字段值
     *
     * @param uocSaleOrderDo
     */
    void updateBatchValue(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 删除扩展字段
     *
     * @param uocSaleOrderDo
     */
    void updateInvalid(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 查询协议单信息
     *
     *@param uocOrderAgreementQryBo
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderAgreement
     */
    UocOrderAgreement getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo);

    /**
     * 协议单列表查询
     *
     * @param uocOrderAgreementQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderAgreement></>
     */
    List<UocOrderAgreement> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo);

    /**
     * 查询销售单总金额总数量
     * @author wenle
     * @date 2022-04-02 09:30:18
     * @param uocSaleOrderQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo);

    /**
     * 软删除，更新del_tag
     * @param saleOrderDo UocSaleOrderDo
     */
    void deleteSaleOrder(UocSaleOrderDo saleOrderDo);

    /**
     * 查询销售单明细
     * @author wenle
     * @date 2022-04-02 14:16:35
     * @param uocSaleOrderItemQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 更新明细发货数量
     * @author wenle
     * @date 2022-04-02 14:37:18
     * @param convertSaleOrderDo 入参
     */
    void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo);

    void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo);

    /**
     * 查询明细各种数量汇总
     * @author wenle
     * @date 2022-04-02 15:14:40
     * @param uocSaleOrderItemQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    UocSaleOrderDo getCollectCountImplOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);
    /**
         * 描述：修改销售单明细验收数量
         *
         * @author: daiyuanyuan
         * @date:   2022-04-02 15:45
         */
    void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo);
    /**
         * 描述：更新三方信息
         *
         * @author: daiyuanyuan
         * @date:   2022-04-06 11:17
         */
    void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo);
    /**
     * 描述：修改销售单及销售单明细销售价
     *
     * @author: daiyuanyuan
     * @date: 2022-04-02 15:45
     */
    void modifySalePrice(UocSaleOrderDo uocSaleOrderDo);

    /***
     *修改明细在途数量
     * @param uocSaleOrderItem
     */
    void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem);
    /***
     *修改明细的验收数量=到货数量
     * @param uocSaleOrderDo
     */
    void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo);

    /***
     * 批量修改明细的验收数量=到货数量
     * @param uocSaleOrderDo
     */
    void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 更新流程实例
     *
     * @param uocOrderProcInst
     */
    void updateProcInst(UocOrderProcInst uocOrderProcInst);

    /**
     * 更新任务实例
     *
     * @param uocOrderTaskInst
     */
    void updateTaskInst(UocOrderTaskInst uocOrderTaskInst);


    void modifyBatchItemChngingCount(UocSaleOrderDo convertImplOrderDo);

    void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo);

    void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo);

    /***
     *修改明细售后在途数量
     * @param uocSaleOrderItem
     */
    void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem);

    /**
     * 描述：修改销售单明细超验标识
     *
     * @author: daiyuanyuan
     * @date:   2022-04-02 15:45
     */
    void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo);

    void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo);

    void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo);

    void updateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo);

    void updateSaleItemArriveAccount(UocSaleOrderDo uocSaleOrderDo);
    /**
     * 描述：修改销售单及销售单明细采购价
     *
     * @author: daiyuanyuan
     * @date: 2022-04-02 15:45
     */
    void modifyPurchasePrice(UocSaleOrderDo uocSaleOrderDo);

    void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo);

    void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo);

    void modifyItemChngCountConfirmAdd(UocSaleOrderDo convertSaleOrderDo);

    void modifyItemChngCountConfirmReduce(UocSaleOrderDo convertSaleOrderDo);

    List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo);

    /**
     * 查询在预订单取消环节的订单
     * @param convertSaleOrderDo
     * @return
     */
    List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo convertSaleOrderDo);
    //查询 需要对账电商的订单列表
    List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo);

    Integer qrySaleCounts(UocSaleOrderDo uocSaleOrderDo);

    List<UocSaleGoodsAfterTakeTypeBo> qryCommityTakeTypes(UocSaleGoodsAfterTakeTypeBo takeTypeBo);

    List<UocSaleOrderItemPlan> selectSaleOrderItemPlan(UocSaleOrderItemPlanBo record);

    List<UocSaleOrderDo> getSaleOrderListByBar(UocSaleOrderQryBo uocSaleOrderQryBo);

    //批量同步销售单
    void batchSyncSale();

    void modifyItemPlan(UocSaleOrderItem saleOrderItem);
    void modifyItemPlanNull(UocSaleOrderItem saleOrderItem);

    void insertSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo);

    void updateSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo);

    List<UocSapOrderSendInfo> getSapSendInfoList(UocSapOrderSendInfo uocSapOrderSendInfo);

    BasePageRspBo<UocSapSendOrderLog> getSapSendInfoListPage(UocQrySapSendOrderLogReqBO uocQrySapSendOrderLogReqBO);

    BasePageRspBo<UocInspOrderTemporarily> selectTempInspOrderListPage(UocQryTempInspListReqBO uocQryTempInspListReqBO);

    int insertSapArrivalInspBatch(List<UocSapArrivalInspInfo> list);

    List<UocInspOrderTemporarily> selectTempInspOrderList(UocInspOrderTemporarily uocInspOrderTemporarily);

    void updateTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily);

    void insertTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily);

    List<UocInspOrderItemTemporarily> selectTempInspOrderItemList(UocInspOrderItemTemporarily uocInspOrderItemTemporarily);

    void updateTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily);

    void insertTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily);

    List<SapArrivalInspInfo> qrySapArrivalInspInfoList(UocSapArrivalInspInfo sapArrivalInspInfo);

    List<String> getMaterialBySkuId(UocSaleOrderQryBo uocSaleOrderQryBo);

    /**
     * 申请开票
     */
    void dealApplyDealInvoice(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 驳回开票
     */
    void dealRejectDealInvoice(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 完成全部开票
     */
    void dealCompleteAllDealInvoice(UocSaleOrderDo uocSaleOrderDo);

    List<UocTransactionPrice> qryTransactionPrice(UocTransactionPrice reqBO);

    /**
     * 订单在线支付回调信息处理
     */
    void dealPayOrderCallback(UocSaleOrderDo uocSaleOrderDo);
}
