package com.tydic.dyc.oc.service.common;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryBO;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryReqBO;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.List;

@HTServiceImpl
public class UocUnifyTodoQryServiceImpl implements UocUnifyTodoQryService {

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Override
    public UocUnifyTodoQryRspBO qryTodoInfo(UocUnifyTodoQryReqBO reqBO) {
        UocUnifyTodoQryRspBO rspBO = judge(reqBO);

        // 通知待办所需变量
        UocUnifyTodoQryBO todoParamJson = new UocUnifyTodoQryBO();

        // 单据创建人（必传）
        switch (reqBO.getObjType()) {
            // 订单
            case 1:
                break;
            // 销售单（三方信息从销售单上来）
            case 2:
                qrySale(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            // 执行单
            case 3:
                break;
            // 发货单
            case 4:
                qryShip(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            // 收货单
            case 5:
                break;
            // 售后服务单
            case 6:
                qryAfter(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            // 支付单
            case 7:
                break;
            // 验收单
            case 8:
                qryInsp(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            // 审批单
            case 9:
                qryAudit(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            // 变更单
            case 10:
                qryChng(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            default:
                break;
        }


        rspBO.setParamJson(JSON.toJSONString(todoParamJson));
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 查询销售单
     */
    private void qrySale(Long orderId, Long saleOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo saleOrderDo = iUocSaleOrderModel.qrySaleOrder(qryBo);

        todoParamJson.setOrderId(saleOrderDo.getOrderId());
        todoParamJson.setSaleOrderId(saleOrderDo.getSaleOrderId());
        todoParamJson.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        todoParamJson.setTotalSaleFee(saleOrderDo.getTotalSaleFee());
        /*if (!StringUtils.isEmpty(saleOrderDo.getProDeliveryId())) {
            todoParamJson.setProDeliveryId(Long.parseLong(saleOrderDo.getProDeliveryId()));
        }*/
        todoParamJson.setProDeliveryName(saleOrderDo.getProDeliveryName());
        todoParamJson.setSaleOrderState(saleOrderDo.getSaleOrderState());
        todoParamJson.setModelSettle(saleOrderDo.getModelSettle());
        todoParamJson.setOrderSource(saleOrderDo.getOrderSource());
        todoParamJson.setPayType(saleOrderDo.getPayType());
        todoParamJson.setSaleOrderCreateUserId(Long.parseLong(saleOrderDo.getCreateOperId()));
        todoParamJson.setIsAgrIgnoreArrive(saleOrderDo.getIsAgrIgnoreArrive());
        todoParamJson.setAreaType(saleOrderDo.getAreaType());
        todoParamJson.setPurchaseMode(saleOrderDo.getPurchaseMode());

        // 查对应协议信息
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource()) && !StringUtils.isEmpty(saleOrderDo.getAgreementId())) {
            UocOrderAgreementQryBo orderAgreementQryBo = new UocOrderAgreementQryBo();
            orderAgreementQryBo.setOrderId(saleOrderDo.getOrderId());
            orderAgreementQryBo.setAgreementId(saleOrderDo.getAgreementId());
            UocOrderAgreement agreementOrderBy = iUocSaleOrderModel.getAgreementOrderBy(orderAgreementQryBo);
            if (agreementOrderBy != null) {
                todoParamJson.setAgreementCode(agreementOrderBy.getAgreementCode());
            }
        }

        //是否跳过发货到货确认
        if (1 == saleOrderDo.getIsAgrIgnoreArrive()) {
            //查询发货单
            UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
            shipOrderQryBo.setOrderId(saleOrderDo.getOrderId());
            shipOrderQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
            List<UocShipOrderDo> shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
            if (!CollectionUtils.isEmpty(shipOrderDoList)) {
                todoParamJson.setShipOrderId(shipOrderDoList.get(0).getShipOrderId());
                todoParamJson.setShipOrderNo(shipOrderDoList.get(0).getShipOrderNo());
                String estimateArrivalTime = new SimpleDateFormat("yyyy-MM-dd").format(shipOrderDoList.get(0).getEstimateArrivalTime());
                todoParamJson.setEstimateArrivalTime(estimateArrivalTime);
            }
        }

        // 三方信息
        // 运营
        rspBO.setProOrgId(Long.parseLong(saleOrderDo.getStakeholder().getProId()));
        // 采购
        rspBO.setPurOrgId(Long.parseLong(saleOrderDo.getStakeholder().getPurOrgId()));
        todoParamJson.setPurOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        // 供应
        rspBO.setSupOrgId(Long.parseLong(saleOrderDo.getStakeholder().getSupId()));

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(saleOrderDo.getCreateOperId()));
    }


    /**
     * 查询发货单
     */
    private void qryShip(Long orderId, Long shipOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setShipOrderId(shipOrderId);
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(qryBo);

        todoParamJson.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
        if (uocShipOrderDo.getEstimateArrivalTime() != null) {
            String estimateArrivalTime = new SimpleDateFormat("yyyy-MM-dd").format(uocShipOrderDo.getEstimateArrivalTime());
            todoParamJson.setEstimateArrivalTime(estimateArrivalTime);
        }

        // 查销售单
        qrySale(orderId, uocShipOrderDo.getSaleOrderId(), rspBO, todoParamJson);

        // 单据创建人id
        if (!StringUtils.isEmpty(uocShipOrderDo.getCreateOperId())) {
            rspBO.setObjCreateUserId(Long.parseLong(uocShipOrderDo.getCreateOperId()));
        } else {
            rspBO.setObjCreateUserId(1L);
        }
    }


    /**
     * 查询售后单
     */
    private void qryAfter(Long orderId, Long afOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocAfOrderQryBo qryBo = new UocAfOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setAfOrderId(afOrderId);
        UocAfOrder uocAfOrder = iUocAfOrderModel.getAfOrderById(qryBo);

        todoParamJson.setAfServCode(uocAfOrder.getAfServCode());
        todoParamJson.setServState(uocAfOrder.getServState());

        // 查销售单
        qrySale(orderId, uocAfOrder.getSaleOrderId(), rspBO, todoParamJson);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocAfOrder.getCreateOperId()));
    }


    /**
     * 查询验收单
     */
    private void qryInsp(Long orderId, Long inspOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocInspOrderQryBo qryBo = new UocInspOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setInspOrderId(inspOrderId);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getInspOrderMain(qryBo);

        // TODO 待办参数，目前还没有验收单的待办

        // 查销售单
        qrySale(orderId, uocInspOrderDo.getSaleOrderId(), rspBO, todoParamJson);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocInspOrderDo.getCreateOperId()));
    }


    /**
     * 查询审批单
     */
    private void qryAudit(Long orderId, Long auditOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocAuditOrderQryBo qryBo = new UocAuditOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setAuditOrderId(auditOrderId);
        UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(qryBo);

        todoParamJson.setAuditOrderCode(uocAuditOrderDo.getAuditOrderCode());

        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(orderId);
        uocApprovalObjQryBo.setAuditOrderId(auditOrderId);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "审批对象信息查询为空");
        }
        todoParamJson.setObjBusiType(uocApprovalObjs.get(0).getObjBusiType());

        // 查销售单
        if (UocDicConstant.OBJ_TYPE.SALE.equals(uocApprovalObjs.get(0).getObjType())) {
            qrySale(orderId, Long.parseLong(uocApprovalObjs.get(0).getObjId()), rspBO, todoParamJson);
        }

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocAuditOrderDo.getCreateOperId()));
    }


    /**
     * 查询变更单
     */
    private void qryChng(Long orderId, Long chngOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setChngOrderId(chngOrderId);
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrder(qryBo);

        todoParamJson.setChngOrderNo(uocChngOrderDo.getChngOrderNo());
        todoParamJson.setChngBusiType(uocChngOrderDo.getBusiType());

        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(orderId);
        uocChngOrderObjQryBo.setChngOrderId(chngOrderId);
        List<UocChngOrderObj> listChngOrderObj = iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
        if (CollectionUtils.isEmpty(listChngOrderObj)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "变更对象信息查询为空");
        }

        // 查销售单
        qrySale(orderId, listChngOrderObj.get(0).getSaleOrderId(), rspBO, todoParamJson);

        // 单据创建人id
        rspBO.setObjCreateUserId(Long.parseLong(uocChngOrderDo.getCreateOperId()));
    }


    /**
     * 入参校验
     *
     * @return reqBO
     */
    private UocUnifyTodoQryRspBO judge(UocUnifyTodoQryReqBO reqBO) {
        if (reqBO.getShareId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参shareId不能为空");
        }
        if (reqBO.getObjId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参objId不能为空");
        }
        if (reqBO.getObjType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参objType不能为空");
        }
//        if (reqBO.getTodoType() == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参todoType不能为空");
//        }
        return new UocUnifyTodoQryRspBO();
    }

}
