package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspCheckReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspCheckRspBO;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceTransaction;
import com.tydic.dyc.oc.transactionservice.UocEcArrvalAcceptanceTransaction;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description sap验收信息校验接口
 * @author Luokan
 * @date 2024/07/08
 **/
@Slf4j
@HTServiceImpl
public class UocDealSapInspCheckServiceImpl implements UocDealSapInspCheckService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private UocArrvalAcceptanceTransaction uocArrvalAcceptanceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private UocEcArrvalAcceptanceTransaction uocEcArrvalAcceptanceTransaction;

    @Override
    public UocDealSapInspCheckRspBO dealSapInspCheck(UocDealSapInspCheckReqBO reqBO) {
        UocDealSapInspCheckRspBO rspBO = UocRu.success(UocDealSapInspCheckRspBO.class);
        //先查询销售明细表，和零食验收明细表，校验是否达到验收条件
        Boolean inspFlag = this.checkInspFlag(reqBO);
        rspBO.setInspFlag(inspFlag);
        if (inspFlag) {
            //修改临时验收单状态
            this.updateTempInsp(reqBO);
            //查询发货单组装验收单生成数据
            this.buildInspParam(reqBO, rspBO);
        }
        return rspBO;
    }

    private void buildInspParam(UocDealSapInspCheckReqBO reqBO, UocDealSapInspCheckRspBO rspBO) {
        //查询销售单
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        rspBO.setIsAgrIgnoreArrive(saleOrderDo.getIsAgrIgnoreArrive());
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
            UocArrvalAcceptanceReqBo uocArrvalAcceptanceReqBo = new UocArrvalAcceptanceReqBo();
            uocArrvalAcceptanceReqBo.setOrderId(reqBO.getOrderId());
            uocArrvalAcceptanceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
            Map<Long, String> shipOrderTaskMap = new HashMap<>();
            if (0 == saleOrderDo.getIsAgrIgnoreArrive()) {
                List<UocOrderTaskInst> saleOrderTask = this.getTaskInfo(reqBO.getOrderId(), reqBO.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
                String saleOrderTaskId = saleOrderTask.get(0).getTaskInstId();
                uocArrvalAcceptanceReqBo.setTaskId(saleOrderTaskId);
                List<UocOrderTaskInst> shipOrderTask = this.getTaskInfo(reqBO.getOrderId(), null, UocDicConstant.OBJ_TYPE.SHIP);
                shipOrderTaskMap = shipOrderTask.stream().collect(Collectors.toMap(UocOrderTaskInst::getObjId, UocOrderTaskInst::getTaskInstId));
            }
            //查询发货明细
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
            uocShipOrderItemQryBo.setOrderId(reqBO.getOrderId());
            UocShipOrderDo shipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            rspBO.setShipOrderIds(shipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getShipOrderId).collect(Collectors.toList()));
            Map<Long, List<UocShipOrderItem>> shipOrderMap = shipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.groupingBy(UocShipOrderItem::getShipOrderId));
            List<UocCreateInspOrderReqShipBo> shipOrderList = new ArrayList<>();
            List<String> shipTskIds = new ArrayList<>();
            for (Long shipOrderId : shipOrderMap.keySet()) {
                UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo = new UocCreateInspOrderReqShipBo();
                uocCreateInspOrderReqShipBo.setShipOrderId(shipOrderId);
                uocCreateInspOrderReqShipBo.setTaskId(shipOrderTaskMap.get(shipOrderId));
                uocCreateInspOrderReqShipBo.setStepId("");
                shipTskIds.add(uocCreateInspOrderReqShipBo.getTaskId());
                List<UocCreateInspOrderReqShipItemBo> shipItemList = new ArrayList<>();
                for (UocShipOrderItem shipOrderItem : shipOrderMap.get(shipOrderId)) {
                    UocCreateInspOrderReqShipItemBo uocCreateInspOrderReqShipItemBo = new UocCreateInspOrderReqShipItemBo();
                    uocCreateInspOrderReqShipItemBo.setShipItemId(shipOrderItem.getShipOrderItemId());
                    uocCreateInspOrderReqShipItemBo.setInspCount(shipOrderItem.getArriveCount());
                    shipItemList.add(uocCreateInspOrderReqShipItemBo);
                }
                uocCreateInspOrderReqShipBo.setShipItemList(shipItemList);
                shipOrderList.add(uocCreateInspOrderReqShipBo);
            }
            uocArrvalAcceptanceReqBo.setShipOrderList(shipOrderList);
            uocArrvalAcceptanceReqBo.setInspFinish(false);
            uocArrvalAcceptanceReqBo.setClosePennyDiff(false);
            uocArrvalAcceptanceReqBo.setUserId(1L);
            //调用验收单验收接口
            UocArrvalAcceptanceRspBo rspBo = uocArrvalAcceptanceTransaction.dealArrvalAcceptance(uocArrvalAcceptanceReqBo);
            if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
                //本地 线程同步es
                syncAgrOrderEs(uocArrvalAcceptanceReqBo, rspBo);
            }
            rspBO.setShipTskIds(shipTskIds);
            rspBO.setTaskId(uocArrvalAcceptanceReqBo.getTaskId());
            rspBO.setOrderSource(saleOrderDo.getOrderSource());
        }else {
            List<UocOrderTaskInst> saleOrderTask = this.getTaskInfo(reqBO.getOrderId(), reqBO.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
            String saleOrderTaskId = saleOrderTask.get(0).getTaskInstId();
            UocEcArrvalAcceptanceReqBo uocEcArrvalAcceptanceReqBo = new UocEcArrvalAcceptanceReqBo();
            uocEcArrvalAcceptanceReqBo.setOrderId(reqBO.getOrderId());
            uocEcArrvalAcceptanceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
            uocEcArrvalAcceptanceReqBo.setTaskId(saleOrderTaskId);
            UocEcArrvalAcceptanceRspBo rspBo = uocEcArrvalAcceptanceTransaction.dealEcArrvalAcceptance(uocEcArrvalAcceptanceReqBo);

            if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
                //本地线程同步es
                syncEcEs(uocEcArrvalAcceptanceReqBo, rspBo);
            }

        }

    }

    private void syncEcEs(UocEcArrvalAcceptanceReqBo reqBo, UocEcArrvalAcceptanceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        list.add(saleBo);

        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        list.add(inspBo);

        for (UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo : rspBo.getShipOrderList()) {
            SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
            shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipBo.setOrderId(reqBo.getOrderId());
            shipBo.setObjId(uocCreateInspOrderReqShipBo.getShipOrderId());
            shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipBo);
        }
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    private void syncAgrOrderEs(UocArrvalAcceptanceReqBo reqBo, UocArrvalAcceptanceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //同步成交服务费
        SyncEsRunnableBo transactionBo = new SyncEsRunnableBo();
        transactionBo.setIndexName(uocIndexConfig.getTransactionIndex());
        transactionBo.setOrderId(reqBo.getOrderId());
        transactionBo.setObjId(rspBo.getInspOrderId());
        transactionBo.setJsonObj(reqBo.getJsonObj());
        transactionBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        transactionBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        list.add(transactionBo);
        list.add(saleBo);
        list.add(inspBo);
        log.debug("验收单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    private List<UocOrderTaskInst> getTaskInfo(Long orderId, Long objId, Integer objType) {
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(orderId);
        qryInst.setObjId(objId);
        qryInst.setObjType(objType);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
        return uocOrderTaskInsts;
    }

    private void updateTempInsp(UocDealSapInspCheckReqBO reqBO) {
        UocInspOrderTemporarily updateUocInspOrderTemporarily = new UocInspOrderTemporarily();
        updateUocInspOrderTemporarily.setOrderId(reqBO.getOrderId());
        updateUocInspOrderTemporarily.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocInspOrderTemporarily.setStatus(UocConstant.TempInspOrderStatus.COMPLETE);
        this.iUocSaleOrderModel.updateTempInspOrder(updateUocInspOrderTemporarily);
    }

    /**
     * 校验是否达到验收条件
     * @param reqBO
     * @return
     */
    private Boolean checkInspFlag(UocDealSapInspCheckReqBO reqBO) {
        Boolean inspFlag = true;
        //查询售后单是否存在未完结的退货验收单
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBO.getOrderId());
        uocAfOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocAfOrder> afOrderList = iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        // 如果没有售后单则直接返回
        if (!CollectionUtils.isEmpty(afOrderList)) {
            // 校验未完成的订单
            for (UocAfOrder afOrder : afOrderList) {
                if (!Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.COMPLATE)
                        && !Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.CANCEL)
                        && !Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS)) {
                    inspFlag = false;
                }
            }
            if (!inspFlag) {
                return inspFlag;
            }
        }
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        //查询临时验收明细
        UocInspOrderItemTemporarily qryInspItemTepm = new UocInspOrderItemTemporarily();
        qryInspItemTepm.setOrderId(reqBO.getOrderId());
        qryInspItemTepm.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocInspOrderItemTemporarily> resultInspItemTemp = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryInspItemTepm);
        Map<Long, UocInspOrderItemTemporarily> resultInspItemTempMap = resultInspItemTemp.stream().collect(Collectors.toMap(UocInspOrderItemTemporarily::getSaleOrderItemId, Function.identity()));
        for (UocSaleOrderItem bo : saleOrderItemList) {
            UocInspOrderItemTemporarily tempInspOrderItem = resultInspItemTempMap.get(bo.getSaleOrderItemId());
            BigDecimal tempInspCount = tempInspOrderItem.getInspCount().subtract(tempInspOrderItem.getReturnCount());
            BigDecimal needInspCount = bo.getArriveCount();
            if (tempInspCount.compareTo(needInspCount) != 0) {
                inspFlag = false;
                break;
            }
        }
        return inspFlag;
    }
}
