package com.tydic.dyc.oc.components.es;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 标题：http方式的客户端配置
 * <p>
 * 说明：http方式的客户端配置，配置9200端口的连接方式
 * <br>
 * 时间：2019/1/1716:40<br>
 * </p>
 *
 * @author hegy
 */
/**
 * 标题：ElasticsearchConfiguration
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/2 15:17
 * 作者 @author 尹栋梁
 */
@Slf4j
@Configuration
public class ElasticsearchConfiguration {
	@Value("${es.cluster.address}")
	private String clusterNodes;

	@Value("${es.source}")
	private String esSource;

	@Value("${ali.es.username:}")
	private String userName;

	@Value("${ali.es.password:}")
	private String password;

	@Value("${es.config.max.connect.numb:600}")
	private int maxConnectNumb;

	@Value("${es.config.connect.timeout:30000}")
	private int connectTimeout;

	@Value("${es.config.socket.timeout:30000}")
	private int socketTimeout;

	@Value("${es.config.request.connect.timeout:6000}")
	private int requestConnectTimeout;

	@Bean("restHighLevelClient")
	public RestHighLevelClient buildHighLevelClient() {
		RestClientBuilder restClientBuilder;

		//设置节点
		if (StringUtils.isEmpty(clusterNodes)) {
			return null;
		}
		//获取到配置的节点地址
		List<String> nodeList = new ArrayList<>(Arrays.asList(clusterNodes.split(",")));
		log.info("es.config.addresses：{}", JSON.toJSONString(nodeList));

		//根据节点列表生成HttpHost数组
		HttpHost[] httpHosts = nodeList.stream().map(HttpHost::create).toArray(HttpHost[]::new);

		restClientBuilder = RestClient.builder(httpHosts);

		//设置最大重试超时时间
//        restClientBuilder.setMaxRetryTimeoutMillis(maxRetryTimeoutMillis);

		//设置监听器，监听节点失败
		restClientBuilder.setFailureListener(new RestClient.FailureListener() {
			@Override
			public void onFailure(Node node) {
				super.onFailure(node);
				System.out.println(node.getHost().getHostName() + "===节点失败了");

			}
		});

		//设置异步线程池
		restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
					if ("AliYun".equals(esSource)) {
						final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
						credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(userName, password));
						httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
					}
					httpAsyncClientBuilder.setDefaultIOReactorConfig(
							IOReactorConfig.custom().setIoThreadCount(maxConnectNumb).build());
					//设置最大连接数
					httpAsyncClientBuilder.setMaxConnTotal(500);
					//设置每个路由的最大连接数
					httpAsyncClientBuilder.setMaxConnPerRoute(1000);
					return httpAsyncClientBuilder;
				}
		);

		//设置获取连接超时时间和嵌套字超时时间，请求超时时间
		//配置完应该相应地调整最大重试超时（默认为30秒），即上面的setMaxRetryTimeoutMillis，一般于最大的那个值一致即60000
		restClientBuilder.setRequestConfigCallback(builder -> builder.setConnectTimeout(connectTimeout)
				.setSocketTimeout(socketTimeout).
				setConnectionRequestTimeout(requestConnectTimeout));

		return new RestHighLevelClient(restClientBuilder);
	}

	@Bean("restClientBuilder")
	public RestClientBuilder buildRestClientBuilder() {
		RestClientBuilder restClientBuilder;

		//设置节点
		if (StringUtils.isEmpty(clusterNodes)) {
			return null;
		}
		//获取到配置的节点地址
		List<String> nodeList = new ArrayList<>(Arrays.asList(clusterNodes.split(",")));
		log.info("es.config.addresses：{}", JSON.toJSONString(nodeList));

		//根据节点列表生成HttpHost数组
		HttpHost[] httpHosts = nodeList.stream().map(HttpHost::create).toArray(HttpHost[]::new);

		restClientBuilder = RestClient.builder(httpHosts);

		//设置最大重试超时时间
//        restClientBuilder.setMaxRetryTimeoutMillis(maxRetryTimeoutMillis);

		//设置监听器，监听节点失败
		restClientBuilder.setFailureListener(new RestClient.FailureListener() {
			@Override
			public void onFailure(Node node) {
				super.onFailure(node);
				System.out.println(node.getHost().getHostName() + "===节点失败了");

			}
		});

		//设置异步线程池
		restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
					if ("AliYun".equals(esSource)) {
						final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
						credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(userName, password));
						httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
						//设置最大连接数
						httpAsyncClientBuilder.setMaxConnTotal(50);
						//设置每个路由的最大连接数
						httpAsyncClientBuilder.setMaxConnPerRoute(100);
					}
					return httpAsyncClientBuilder;
				}
		);

		//设置获取连接超时时间和嵌套字超时时间，请求超时时间
		//配置完应该相应地调整最大重试超时（默认为30秒），即上面的setMaxRetryTimeoutMillis，一般于最大的那个值一致即60000
		restClientBuilder.setRequestConfigCallback(builder -> builder.setConnectTimeout(connectTimeout)
				.setSocketTimeout(socketTimeout).
				setConnectionRequestTimeout(requestConnectTimeout));

		return restClientBuilder;
	}
}

