package com.tydic.dyc.oc.model.order.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 标题：UocConfEffective
 * 说明：时效配置
 * 时间：2022/4/10 16:14
 *
 * @author 文乐
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocConfEffective implements Serializable {
    private static final long serialVersionUID = 6770506535244052565L;
    //时效配置ID 主键")
    private Long effectiveId;

    //时效配置编码")
    private String effectiveCode;

    //业务类型编码")
    private String businessTypeCode;

    //供应商编码")
    private String supplierNo;

    //供应商名称")
    private String supplierName;

    //时效 毫秒数")
    private Long aging;

    //来源编码")
    private String sourceCode;

    //操作时间")
    private Date operatingTime;

    //操作时间 开始")
    private Date operatingTimeStart;

    //操作时间 结束")
    private Date operatingTimeEnd;

    //操作人ID")
    private String operatorId;

    //操作人名称")
    private String operatorName;

    //删除标志1已删除")
    private Integer delTag;

    //排序")
    private String orderBy;
    
    private Set<String> effectiveCodeSet;
    
    private Set<String> supplierNoSet;
    
    private Set<String> busiTypeCodeSet;
}
