package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalLogQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApprovalLogItemBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocApprovalLogQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApprovalLogQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：UocApprovalLogQryServiceImpl
 * 说明：审批日志查询
 * 时间：2022/4/7 20:28
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocApprovalLogQryServiceImpl implements UocApprovalLogQryService{

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Override
    public UocApprovalLogQryRspBo qryApprovalLog(UocApprovalLogQryReqBo reqBo) {
        validateArg(reqBo);
        UocApprovalLogQryBo uocApprovalLogQryBo = new UocApprovalLogQryBo();
        uocApprovalLogQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryApprovalLog(uocApprovalLogQryBo);
        UocApprovalLogQryRspBo success = UocRu.success(UocApprovalLogQryRspBo.class);
        List<UocApprovalLog> uocApprovalLogList = uocAuditOrderDo.getUocApprovalLogList();
        if (CollectionUtils.isEmpty(uocApprovalLogList)) {
            return success;
        } else {
            UocSysDictionaryQryBo dictionaryQryBo = new UocSysDictionaryQryBo();
            dictionaryQryBo.setPCode(UocConstant.AUDIT_TYPE.P_CODE);
            List<UocSysDictionaryDo> uocSysDictionaryDos = iUocSysDictionaryModel.qryDicList(dictionaryQryBo);
            Map<String, String> auditDicMap = uocSysDictionaryDos.stream().collect(Collectors.toMap(UocSysDictionaryDo::getCode, UocSysDictionaryDo::getTitle));
            List<UocApprovalLog> uocApprovalLogs = uocApprovalLogList.stream().sorted(Comparator.comparing(UocApprovalLog::getCreateTime)).collect(Collectors.toList());
            List<UocApprovalLogItemBO> uocApprovalLogItemBOS = new ArrayList<>(uocApprovalLogs.size());
            for (int i = 0; i < uocApprovalLogs.size(); i++) {
                UocApprovalLogItemBO approvalLogItemBO = UocRu.js(uocApprovalLogs.get(i), UocApprovalLogItemBO.class);
                approvalLogItemBO.setAuditResultStr(auditDicMap.get(Convert.toStr(approvalLogItemBO.getAuditResult())));
                if ( i == 0 ) {
                    approvalLogItemBO.setAuditDiachronic(null);
                } else {
                    long between = DateUtil.between(uocApprovalLogs.get(i - 1).getCreateTime(), uocApprovalLogs.get(i).getCreateTime(), DateUnit.SECOND);
                    approvalLogItemBO.setAuditDiachronic(secondToTime(between));
                }
                uocApprovalLogItemBOS.add(approvalLogItemBO);
            }
            success.setAuditLogItems(uocApprovalLogItemBOS);
        }
        return success;
    }

    /**
     * 将秒数转换为日时分秒
     */
    public static String secondToTime(long second){
        long days = second / 86400;
        second = second % 86400;
        long hours = second / 3600;
        second = second % 3600;
        long minutes = second /60;
        second = second % 60;
        if(days>0){
            return days + "天" + hours + "小时" + minutes + "分" + second + "秒";
        }else{
            return hours + "小时" + minutes + "分" + second + "秒";
        }
    }

    private void validateArg(UocApprovalLogQryReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getAuditOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "auditOrderId不能为空");
        }
    }
}
