package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfEvaluate;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateDealReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateDealRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 标题：UocProOrderEvaluateDealAbilityServiceImpl
 * 说明：订单评价配置处理API 实现类
 * 时间：2021/4/6 15:03
 * 作者 何秀全
 */
@HTServiceImpl
public class UocProOrderEvaluateDealServiceImpl implements UocProOrderEvaluateDealService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocProOrderEvaluateDealRspBo dealOrderEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        validateArgs(reqBo);
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete()) {
            //删除
            deleteOrderEvaluate(reqBo);
        }
        if (null == reqBo.getEvaluateId() || 0L == reqBo.getEvaluateId()) {
            //新增
            addConfEvaluate(reqBo);
        } else {
            //修改
            modifyConfEvaluate(reqBo);
        }

        return UocRu.success(UocProOrderEvaluateDealRspBo.class);
    }

    /**
     * 修改评价配置
     *
     * @param reqBo
     */
    private void modifyConfEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        UocConfEvaluate uocConfEvaluate = new UocConfEvaluate();
        uocConfEvaluate.setEvaluationDeadline(reqBo.getEvaluationDeadline());
        uocConfEvaluate.setSystemAutomaticPraise(reqBo.getSystemAutomaticPraise());
        uocConfEvaluate.setWhetherReview(reqBo.getWhetherReview());
        uocConfEvaluate.setReviewDeadline(reqBo.getReviewDeadline());
        uocConfEvaluate.setOperatingTime(new Date());
        uocConfEvaluate.setOperatorId(String.valueOf(reqBo.getUserId()));
        uocConfEvaluate.setOperatorName(reqBo.getName());
        uocConfEvaluate.setEvaluateId(reqBo.getEvaluateId());
        iUocOrderModel.modifyConfEvaluate(uocConfEvaluate);
    }

    /**
     * 新增评价配置
     *
     * @param reqBo
     */
    private void addConfEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        UocConfEvaluate checkConfEvaluate = new UocConfEvaluate();
        checkConfEvaluate.setApplicationUnitNo(reqBo.getApplicationUnitNo());
        int checkBy = iUocOrderModel.getCheckConfEvaluate(checkConfEvaluate);
        if (0 != checkBy) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ORD_EVA_DEAL_ABILITY_ERROR, "已存在该应用单位的配置，请重新设置。");
        }
        UocConfEvaluate uocConfEvaluate = new UocConfEvaluate();
        uocConfEvaluate.setApplicationUnitNo(reqBo.getApplicationUnitNo());
        uocConfEvaluate.setEvaluateId(IdUtil.nextId());
        uocConfEvaluate.setApplicationUnitName(reqBo.getApplicationUnitName());
        uocConfEvaluate.setEvaluationDeadline(reqBo.getEvaluationDeadline());
        uocConfEvaluate.setSystemAutomaticPraise(reqBo.getSystemAutomaticPraise());
        uocConfEvaluate.setWhetherReview(reqBo.getWhetherReview());
        uocConfEvaluate.setReviewDeadline(reqBo.getReviewDeadline());
        uocConfEvaluate.setOperatingTime(new Date());
        uocConfEvaluate.setOperatorId(String.valueOf(reqBo.getUserId()));
        uocConfEvaluate.setOperatorName(reqBo.getUsername());
        iUocOrderModel.addConfEvaluate(uocConfEvaluate);
    }


    /**
     * 删除订单评价配置信息
     *
     * @param reqBo 入参
     */
    private void deleteOrderEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        UocConfEvaluate uocConfEvaluate = iUocOrderModel.getConfEvaluateById(reqBo.getEvaluateId());
        if (null == uocConfEvaluate) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ORD_EVA_DEAL_ABILITY_ERROR, "入参[effectiveId]查询为空，无法删除");
        } else if (UocConstant.ApplicationUnitNo.GROUP.equals(uocConfEvaluate.getApplicationUnitNo())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ORD_EVA_DEAL_ABILITY_ERROR, "该数据为系统预设值，不允许删除");
        }
        iUocOrderModel.deleteConfEvaluate(uocConfEvaluate);
    }

    /**
     * 入参校验
     *
     * @param reqBo 入参
     */
    private void validateArgs(UocProOrderEvaluateDealReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete()) {
            if (null == (reqBo.getEvaluateId()) || 0L == reqBo.getEvaluateId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参删除[evaluateId]不能为空");
            }
            return;
        }
        if (null == (reqBo.getEvaluateId()) || 0L == reqBo.getEvaluateId()) {
            //新增
            if (!StringUtils.hasText(reqBo.getApplicationUnitNo())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参新增[applicationUnitNo]不能为空");
            }
            if (!StringUtils.hasText(reqBo.getApplicationUnitName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参新增[applicationUnitName]不能为空");
            }
        }
        if (null == (reqBo.getEvaluationDeadline()) || 0L > reqBo.getEvaluationDeadline()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[evaluationDeadline]不能为空，且大于等于0");
        }
        if (null == reqBo.getSystemAutomaticPraise() || (0 != reqBo.getSystemAutomaticPraise() && 1 != reqBo.getSystemAutomaticPraise())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参新增[systemAutomaticPraise]不合法");
        }
        if (null == reqBo.getWhetherReview()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参新增[whetherReview]不能为空");
        } else if (0 == reqBo.getWhetherReview()) {
            reqBo.setReviewDeadline(null);
        } else if (1 == reqBo.getWhetherReview()) {
            if (null == (reqBo.getReviewDeadline()) || 0L > reqBo.getReviewDeadline()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[reviewDeadline]不能为空，且大于等于0");
            }
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参新增[whetherReview]不合法");
        }
    }
}
