package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemUpdatePlanReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemUpdatePlanRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description:变更销售单计划实现
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/27 16:37
 */
@HTServiceImpl
public class UocSaleOrderItemUpdatePlanServiceImpl implements UocSaleOrderItemUpdatePlanService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocSaleOrderItemUpdatePlanRspBo updateSaleOrderItemPlan(UocSaleOrderItemUpdatePlanReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setSaleOrderItemId(reqBo.getSaleOrderItemId());
        UocSaleOrderDo listSaleOrderItem = iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItems = listSaleOrderItem.getSaleOrderItems();
        if (saleOrderItems.isEmpty()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR, "销售单明细不存在");
        }
        UocSaleOrderItem saleOrderItem = saleOrderItems.get(0);
        saleOrderItem.setPlanId(reqBo.getPlanId());
        saleOrderItem.setPlanNo(reqBo.getPlanNo());
        saleOrderItem.setPlanItemId(reqBo.getPlanItemId());
        saleOrderItem.setPlanItemNo(reqBo.getPlanItemNo());
        saleOrderItem.setPlanUnit(reqBo.getPlanUnit());
        saleOrderItem.setSkuMaterialId(reqBo.getSkuMaterialId());
        saleOrderItem.setSkuMaterialCode(reqBo.getSkuMaterialCode());
        saleOrderItem.setSkuMaterialName(reqBo.getSkuMaterialName());
        saleOrderItem.setPlanSource(reqBo.getPlanSource());
        saleOrderItem.setPlanConversionRate(reqBo.getPlanConversionRate());
        iUocSaleOrderModel.modifyItemPlanNull(saleOrderItem);
        return UocRu.success(UocSaleOrderItemUpdatePlanRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocSaleOrderItemUpdatePlanReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getSaleOrderItemId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单明细ID不能为空");
        }
    }


}
