package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.lang.annotation.ElementType;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：UocPaymentCallbackServiceImpl
 * 说明：付款回调
 * 时间：2022/4/8 17:35
 * 作者： 周中贤
 */
@Slf4j
@HTServiceImpl
public class UocPaymentCallbackServiceImpl implements UocPaymentCallbackService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;


    /**
     * 付款回调
     * 根据回调支付状态修改应付单和销售单，并更新ES
     */
    @Override
    public UocPaymentCallbackRspBO dealCallback(UocPaymentCallbackReqBO reqBO) {
        val(reqBO);
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            UocSaleOrderDo modifyEsBO = new UocSaleOrderDo();
            /**
             * 1.查询销售单ID
             */
            Long saleOrderID = uocPaymentCallbackBO.getSaleOrderId();
            if (!UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocPaymentCallbackBO.getPayType())) {
                saleOrderID = qryBeforeData(uocPaymentCallbackBO);
            }
            if(!uocPaymentCallbackBO.getPayResult()){
                /**
                 * 回调支付结果->false
                 * 修改销售单支付状态为’付款失败‘并同步ES
                 */
                log.error("结算回调支付状态为false");
                //修改销售单支付状态为未支付
                UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                uocSaleOrderDo.setOrderId(uocPaymentCallbackBO.getOrderId());
                uocSaleOrderDo.setSaleOrderId(saleOrderID);
                //支付类型
                uocSaleOrderDo.setPayMod(uocPaymentCallbackBO.getPayMod());
                //支付状态->付款失败
                uocSaleOrderDo.setPayState(UocDicConstant.PAY_STATE.PAY_FAILED);
                iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);

                modifyEsBO.setPayMod(uocPaymentCallbackBO.getPayMod());
                modifyEsBO.setPayState(UocDicConstant.PAY_STATE.PAY_FAILED);
            }else{
                /**
                 * 回调支付结果->true
                 * 修改应付单和销售单，并同步ES
                 */
                if (!UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocPaymentCallbackBO.getPayType())) {
                    //1)、修改应付单(支付状态和已付金额)
                    UocOrderShouldPay set = new UocOrderShouldPay();
                    //支付状态->已完成
                    set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
                    //已付金额
                    set.setPaidAmount(uocPaymentCallbackBO.getShouldPayMoney());
                    set.setUpdateTime(new Date());
                    UocOrderShouldPay where = new UocOrderShouldPay();
                    where.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
                    iUocPayOrderModel.modifyOrderShouldPayMain(set, where);
                }
                //2）、修改销售单
                UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                uocSaleOrderDo.setOrderId(uocPaymentCallbackBO.getOrderId());
                uocSaleOrderDo.setSaleOrderId(saleOrderID);
                //实付金额
                uocSaleOrderDo.setUsedFee(uocPaymentCallbackBO.getShouldPayMoney());
                //支付类型
                uocSaleOrderDo.setPayMod(uocPaymentCallbackBO.getPayMod());
                //支付状态判断
                Integer payStatus =  payJudgeMethod(uocPaymentCallbackBO,saleOrderID);
                log.info("订单状态："+payStatus);
                //支付状态->已付款
                uocSaleOrderDo.setPayState(payStatus);
                iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);

                //实付金额
                modifyEsBO.setUsedFee(uocPaymentCallbackBO.getShouldPayMoney());
                //支付类型
                modifyEsBO.setPayMod(uocPaymentCallbackBO.getPayMod());
                //支付状态->已付款
                modifyEsBO.setPayState(payStatus);
            }
            /**
             * ES更新
             */
            modifyEsBO.setSaleOrderId(saleOrderID);

            syncEs(modifyEsBO);
        }
        return UocRu.success(UocPaymentCallbackRspBO.class);
    }

    /**
     *  查询销售单ID
     */
    private Long qryBeforeData(UocPaymentCallbackBO uocPaymentCallbackBO) {
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
        //1)、查询应付单信息
        UocOrderShouldPay orderShouldPay = iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
        if(orderShouldPay == null){
            log.error("根据结算应付id查询应付单为空,传入的fscShouldPayId为：{}", uocPaymentCallbackBO.getFscShouldPayId());
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "根据结算应付id查询应付单为空");
        }
        //单据id
        Long objectId = orderShouldPay.getObjectId();
        //单据类型
        Integer objectType = orderShouldPay.getObjectType();
        uocPaymentCallbackBO.setObjectType(objectType);
        //2)、找到销售单ID
        Long saleOrderID = qrySaleOrderID(uocPaymentCallbackBO, objectId, objectType);
        if(saleOrderID == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单ID为空");
        }
        return saleOrderID;
    }

    /**
     *
     * @param callbackBO
     * @param saleOrderID
     * @return
     */
   private Integer payJudgeMethod(UocPaymentCallbackBO callbackBO,Long saleOrderID){

       //查询销售主体
       UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
       uocSaleOrderDo.setSaleOrderId(saleOrderID);
       UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
       Integer patStauts = saleOrderMain.getPayState();
       String saleOrderState = saleOrderMain.getSaleOrderState();
       Integer payType = Integer.valueOf(saleOrderMain.getPayType());


       //判断支付方式
       if(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payType) || UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(payType)){
           //预付款或账期
           patStauts = UocDicConstant.PAY_STATE.PAYED;
       }else if(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payType)){
          //分阶段
          //todo 不是质保金阶段就是部分付款，否则已付款
           patStauts = UocDicConstant.PAY_STATE.PAYED;
           //先查询支付配置
           UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
           uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderID);
           uocSaleOrderPayConfQryBo.setUserType(UocDicConstant.USE_TYPE.PUR);
           uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED);
           List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
           if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
               UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
               UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
               uocOrderShouldPay.setOrderId(callbackBO.getOrderId());
               uocOrderShouldPay.setObjectType(callbackBO.getObjectType());
               //存在到货款比例，则验证所有发货单已经付款完成
               if (null != payConf.getVerPaySup() && BigDecimal.ZERO.compareTo(payConf.getVerPaySup()) != 0) {
                   //查询该销售单下的所有发货单
                   UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
                   shipOrderQryBo.setSaleOrderId(saleOrderID);
                   List<UocShipOrderDo> shipOrderDoList = iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
                   //发货单集合
                   uocOrderShouldPay.setObjectIdList(shipOrderDoList.stream().map(obj -> obj.getShipOrderId()).collect(Collectors.toList()));
                   List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
                   boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);

                   //所有发货单都做了到货处理且所有应付单都已支付
                   if((UocStateConstants.SaleOrder.XS_DH_DH.equals(saleOrderState) ||
                           UocStateConstants.SaleOrder.XS_YS_YS.equals(saleOrderState) && payFlag)){
                       //patStauts = UocDicConstant.PAY_STATE.PAYED;
                   }else{
                       patStauts = UocDicConstant.PAY_STATE.PART_PAY;
                       return patStauts;
                   }
               }
               //存在验收款比例，则验证所有验收单已经付款完成
               if (null != payConf.getPilPaySup() && BigDecimal.ZERO.compareTo(payConf.getPilPaySup()) != 0) {
                   //查询该销售单下的所有验收单
                   UocInspOrderQryBo inspOrderQryBo = new UocInspOrderQryBo();
                   inspOrderQryBo.setSaleOrderId(saleOrderID);
                   List<UocInspOrderDo> inspOrderList = iUocInspOrderModel.getListInspOrder(inspOrderQryBo);
                   //验收单集合
                   uocOrderShouldPay.setObjectIdList(inspOrderList.stream().map(obj -> obj.getInspOrderId()).collect(Collectors.toList()));
                   List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
                   boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);

                   //所有发货单都做了验收处理且所有应付单都已支付
                   if(UocStateConstants.SaleOrder.XS_YS_YS.equals(saleOrderState) && payFlag){
                       //patStauts = UocDicConstant.PAY_STATE.PAYED;
                   }else{
                       patStauts = UocDicConstant.PAY_STATE.PART_PAY;
                       return patStauts;
                   }
               }
               //存在质保金比例，则验收质保金应付单已付款
               if (null != payConf.getQuaPaySup() && BigDecimal.ZERO.compareTo(payConf.getQuaPaySup()) != 0) {
                   uocOrderShouldPay.setObjectIdList(Arrays.asList(saleOrderID));
                   uocOrderShouldPay.setShouldPayType(UocDicConstant.SHOULD_PAY_TYPE.GUARANTEE);
                   List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
                   boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);
                   if(UocStateConstants.SaleOrder.XS_YS_YS.equals(saleOrderState) && payFlag){
                       //do nothing
                   }else{
                       patStauts = UocDicConstant.PAY_STATE.PART_PAY;
                       return patStauts;
                   }
               }
           }
       }/*else{

           UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
           uocOrderShouldPay.setOrderId(callbackBO.getOrderId());
           uocOrderShouldPay.setObjectType(callbackBO.getObjectType());

           //账期
           if(UocDicConstant.OBJ_TYPE.SHIP.equals(callbackBO.getObjectType())){
               //到货节点
               //查询该销售单下的所有发货单
               UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
               shipOrderQryBo.setSaleOrderId(saleOrderID);
               List<UocShipOrderDo> shipOrderDoList = iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
               //发货单集合
               uocOrderShouldPay.setObjectIdList(shipOrderDoList.stream().map(obj -> obj.getShipOrderId()).collect(Collectors.toList()));
               List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
               boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);

               //所有发货单都做了到货处理且所有应付单都已支付
               if((UocStateConstants.SaleOrder.XS_DH_DH.equals(saleOrderState) ||
                        UocStateConstants.SaleOrder.XS_YS_YS.equals(saleOrderState) && payFlag)){
                   patStauts = UocDicConstant.PAY_STATE.PAYED;
               }else{
                   patStauts = UocDicConstant.PAY_STATE.PART_PAY;
               }

           }else {
               //验收节点
               //查询该销售单下的所有验收单
               UocInspOrderQryBo inspOrderQryBo = new UocInspOrderQryBo();
               inspOrderQryBo.setSaleOrderId(saleOrderID);
               List<UocInspOrderDo> inspOrderList = iUocInspOrderModel.getListInspOrder(inspOrderQryBo);
               //验收单集合
               uocOrderShouldPay.setObjectIdList(inspOrderList.stream().map(obj -> obj.getInspOrderId()).collect(Collectors.toList()));
               List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
               boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);

               //所有发货单都做了验收处理且所有应付单都已支付
               if(UocStateConstants.SaleOrder.XS_YS_YS.equals(saleOrderState) && payFlag){
                   patStauts = UocDicConstant.PAY_STATE.PAYED;
               }else{
                   patStauts = UocDicConstant.PAY_STATE.PART_PAY;
               }
           }

       }*/
       return patStauts;
   }

    /**
     * 查询销售单Id
     */
    private Long qrySaleOrderID(UocPaymentCallbackBO uocPaymentCallbackBO, Long objectId, Integer objectType) {
        Long saleOrderId;
        if(UocDicConstant.OBJ_TYPE.SALE.equals(objectType)){
            //销售单类型
            saleOrderId = objectId;
        }else if(UocDicConstant.OBJ_TYPE.SHIP.equals(objectType)){
            //发货单类型 发货单找到销售单id
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocShipOrderQryBo.setShipOrderId(objectId);
            UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if(uocShipOrderDo == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单为空");
            }
            saleOrderId = uocShipOrderDo.getSaleOrderId();
        }else if(UocDicConstant.OBJ_TYPE.INSPECTION.equals(objectType)){
            //验收单类型 验收单找到销售单Id
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocInspOrderQryBo.setInspOrderId(objectId);
            UocInspOrderDo inspOrderMain = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            if(inspOrderMain == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询验收单为空");
            }
            saleOrderId = inspOrderMain.getSaleOrderId();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "暂仅支持销售单、发货单、验收单单据类型");
        }
        return saleOrderId;
    }

    private void val(UocPaymentCallbackReqBO reqBO) {
        if(reqBO == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getUocPaymentCallbackBOS())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[回调信息集合]为空");
        }
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            if(uocPaymentCallbackBO == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[支付是否成功]为空");
            }
            if(uocPaymentCallbackBO.getPayResult()){
                if(uocPaymentCallbackBO.getFscShouldPayId() == null && !UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocPaymentCallbackBO.getPayType())){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[结算应付ID]为空");
                }
                if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocPaymentCallbackBO.getPayType()) && null == uocPaymentCallbackBO.getSaleOrderId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[销售单Id]为空");
                }
                /*if(uocPaymentCallbackBO.getOrderId() == null){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[订单ID]为空");
                }*/
                if(uocPaymentCallbackBO.getShouldPayMoney() == null){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[应付金额]为空");
                }
            }
        }
    }

    /**
     * 同步ES
     */
    private void syncEs(UocSaleOrderDo uocSaleOrderDo) {
        //1.未支付状态应付订单列表
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(uocSaleOrderDo.getOrderId());
        uocOrderShouldPay.setObjectId(uocSaleOrderDo.getSaleOrderId());
        uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderShouldPay.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
        List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
        JSONArray jsonArray = new JSONArray();
        if(!CollectionUtils.isEmpty(listOrderShouldPay)){
            for (UocOrderShouldPay item : listOrderShouldPay) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("fscShouldPayId",item.getFscShouldPayId());
                jsonObject.put("shouldPayAmount",item.getShouldPayAmount());
                jsonObject.put("paidAmount",item.getPaidAmount());
                jsonObject.put("shouldPayType",item.getShouldPayType());
                jsonArray.add(jsonObject);
            }
        }
        JSONObject jsonObj = new JSONObject();
        if(!CollectionUtils.isEmpty(jsonArray)){
            //未支付状态应付订单列表
            jsonObj.put(UocConstant.ES_MAIN_OTHER.ORDER_SHOULD_PAY_LIST,jsonArray.toString());
        }
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        //objId
        uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        //indexName
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        if(uocSaleOrderDo.getUsedFee() != null){
            //实付金额
            jsonObj.put(UocConstant.ES_MAIN_OTHER.USED_FEE,uocSaleOrderDo.getUsedFee());
        }
        Map<String, Map<String, String>> dic = getDic();
        //支付类型
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_MOD,uocSaleOrderDo.getPayMod());
        Map<String, String> payModMap = dic.get(UocDicConstant.PAY_MOD.P_CODE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_MOD_STR,payModMap.get(Convert.toStr(uocSaleOrderDo.getPayMod())));
        //支付状态
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE,uocSaleOrderDo.getPayState());
        Map<String, String> payStateMap = dic.get(UocDicConstant.PAY_STATE.P_CODE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR,payStateMap.get(Convert.toStr(uocSaleOrderDo.getPayState())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("paymentCallBack同步ES入参为：{}",JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.PAY_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_MOD.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
