package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQrySupReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQrySupRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：类名称:UocQrySupNoServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/11 16:26
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocQrySupNoServiceImpl implements UocQrySupNoService{
    @Autowired
    private IUocOrderModel orderModel;
    @Override
    public UocQrySupRspBo qrySupNo(UocQrySupReqBo reqBo) {
        UocQrySupRspBo uocQrySupRspBo = UocRu.success(UocQrySupRspBo.class);

        validateArg(reqBo);
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        if (CollectionUtil.isNotEmpty(uocOrderStakeholderQryBos)) {
            String supId = uocOrderStakeholderQryBos.get(0).getSupId();
            uocQrySupRspBo.setSupId(supId);
        }
        return uocQrySupRspBo;
    }
    private void validateArg(UocQrySupReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryShipOrderDetailsReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
    }
}
