package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapSendOrderLog;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description sap回调信息查询接口
 * @author Luokan
 * @date 2024/07/08
 **/

@HTServiceImpl
public class UocQrySapSendOrderLogServiceImpl implements UocQrySapSendOrderLogService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQrySapSendOrderLogRspBO qrySapSendOrderLog(UocQrySapSendOrderLogReqBO reqBO) {
        UocQrySapSendOrderLogRspBO rspBO = new UocQrySapSendOrderLogRspBO();
        BasePageRspBo<UocSapSendOrderLog> result = this.iUocSaleOrderModel.getSapSendInfoListPage(reqBO);
        /*if (!CollectionUtils.isEmpty(result.getRows())) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderIdList(result.getRows().stream().map(UocSapSendOrderLog::getSaleOrderId).collect(Collectors.toList()));
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            Map<Long, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSaleOrderId));
            for (UocSapSendOrderLog bo : result.getRows()) {
                bo.setSapOrderNo(saleOrderItemMap.get(bo.getSaleOrderId()).get(0).getSapOrderNo());
            }
        }*/
        rspBO.setRows(result.getRows());
        rspBO.setPageNo(result.getPageNo());
        rspBO.setTotal(result.getTotal());
        rspBO.setRecordsTotal(result.getRecordsTotal());
        return rspBO;
    }
}
