package com.tydic.dyc.oc.components.es.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 标题:UocEsSyncTodo
 * 说明:代办
 * 时间:2022/3/18 12:43
 * 作者:罗有
 */

@Slf4j
@Component
public class UocEsSyncTodoDelete implements IUocEsSync {

	@Autowired
	private UocIndexConfig uocIndexConfig;

	@Override
	public String indexName() {
		return uocIndexConfig.getTodoIndexDelete();
	}

	@Override
	public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
		IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
		iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
		UocEsTodoDeleteBo uocEsTodoDeleteBo = new UocEsTodoDeleteBo();
		Query query = new Query();
		Term term = new Term();
		term.setId(reqBo.getObjId());
		query.setTerm(term);
		uocEsTodoDeleteBo.setQuery(query);
		iUocEsSyncQryRspBo.setJsonObj(JSON.parseObject(JSON.toJSONString(uocEsTodoDeleteBo)));
		log.info("删除代办参数:{}", iUocEsSyncQryRspBo.getJsonObj().toJSONString());
		return iUocEsSyncQryRspBo;
	}

	@Data
@EqualsAndHashCode(callSuper=false)
	private class UocEsTodoDeleteBo {
		private Query query;
	}

	@Data
@EqualsAndHashCode(callSuper=false)
	private class Query {
		private Term term;
	}

	@Data
@EqualsAndHashCode(callSuper=false)
	private class Term {
		private Long id;
	}
}
