package com.tydic.dyc.oc.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 标题:UocSystemConfig
 * 说明:订单系统配置，对应常量类：com.tydic.dyc.oc.constants.UocSystemConstant
 * 时间:2023/7/27 15:15
 * 作者:田桂银
 */
@Component
@Data
public class UocSystemConfig {

    /**
     * 系统名称，用于系统识别，默认值为："DYC"，例如：需要调用外部扩展服务时，如果为DYC，则使用迪易采默认实现，如果为其它，则调用扩展api（根据实际业务情况决定是否需要使用这个通用配置）
     */
    @Value("${dyc.system.name:DYC}")
    private String systemName;


}


