package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderCancelTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderCancelServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/6 16:11
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderCancelServiceImpl implements UocAfterOrderCancelService {
    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    @Autowired
    private UocAfterOrderCancelTransaction uocAfterOrderCancelTransaction;

    @Override
    public UocAfterOrderCancelRspBo cancelAfterOrder(UocAfterOrderCancelReqBo reqBo) {

        UocAfterOrderCancelRspBo rspBo = this.uocAfterOrderCancelTransaction.cancelAfterOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义销售单数据同步BO
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncSaleEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        //设置操作标识
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);

        //定义发货单数据同步BO
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        //设置订单ID
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncShipEsRunnableBo.setObjId(rspBo.getShipOrderId());
        //设置操作标识
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncShipEsRunnableBo);

        //定义售后单数据同步BO
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        //设置订单ID
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncAfEsRunnableBo.setObjId(reqBo.getAfOrderId());
        //设置操作标识
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncAfEsRunnableBo);

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
