package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceReqTaskBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocApproveCreateServiceImpl
 * 说明:
 * 时间:2022/3/10 16:26
 * 作者:田桂银
 */
@HTServiceImpl
public class UocApproveCreateServiceImpl implements UocApproveCreateService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public UocApproveCreateServiceRspBo createApprove(UocApproveCreateServiceReqBo reqBo) {
        validateArg(reqBo);
        UocApproveCreateServiceRspBo rspBo = UocRu.success(UocApproveCreateServiceRspBo.class);
        long auditId = IdUtil.nextId();
        UocAuditOrderDo auditDo = UocRu.js(reqBo, UocAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(reqBo.getOrderId());
        auditDo.setAuditOrderStatus(UocStateConstants.AUDIT_ORDER_STATUS.WAIT_AUDIT);
        List<UocApprovalObj> objList = new ArrayList<>();
        auditDo.setApprovalObjs(objList);
        UocApprovalObj approvalObj = new UocApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBo.getObjId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrderId());
        approvalObj.setObjType(reqBo.getObjType());
        approvalObj.setObjBusiType(reqBo.getObjBusiType());

        UocApprovalLog uocApprovalLog = new UocApprovalLog();
        uocApprovalLog.setAuditOrderId(auditId);
        uocApprovalLog.setId(IdUtil.nextId());
        uocApprovalLog.setOperid(reqBo.getUserId().toString());
        uocApprovalLog.setOperName(reqBo.getName());
        uocApprovalLog.setOperDept(reqBo.getOrgId()+"");
        uocApprovalLog.setCreateTime(new Date());
        uocApprovalLog.setObjNum(objList.size());
        uocApprovalLog.setObjType(reqBo.getObjBusiType());
        uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(uocApprovalLog);

        iUocAuditOrderModel.saveAudit(auditDo);

        rspBo.setAuditOrderId(auditId);
        return rspBo;
    }

    private void validateArg(UocApproveCreateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocApproveCreateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象id，例如销售单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象类型]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjBusiType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象业务类型]不能为空");
        }

    }
}


