package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.service.domainservice.bo.UocConfirmReceiptShipOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptRspBo;
import com.tydic.dyc.oc.transactionservice.UocShipOrderConfirmReceiptTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：发货单确认收货实现类
 */
@Slf4j
@HTServiceImpl
public class UocShipOrderConfirmReceiptServiceImpl implements UocShipOrderConfirmReceiptService {

	/**
	 * 索引配置
	 */
	@Autowired
	private UocIndexConfig uocIndexConfig;

	/**
	 * 统一线程池
	 */
	@Autowired
	private UocThreadPool uocThreadPool;

	/**
	 * 发货单确认收货事务层
	 */
	@Autowired
	private UocShipOrderConfirmReceiptTransaction uocShipOrderConfirmReceiptTransaction;

	/**
	 * 发货单确认收货
	 */
	@Override
	public UocShipOrderConfirmReceiptRspBo dealConfirmReceipt(UocShipOrderConfirmReceiptReqBo reqBo) {
		//调用发货单确认收货事务层，发货单确认收货
		UocShipOrderConfirmReceiptRspBo rspBo = this.uocShipOrderConfirmReceiptTransaction.dealConfirmReceipt(reqBo);

		if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
			//调用同步ES
			this.syncEs(reqBo, rspBo);
		}

		return rspBo;
	}

	/**
	 * 同步ES
	 */
	private void syncEs(UocShipOrderConfirmReceiptReqBo reqBo, UocShipOrderConfirmReceiptRspBo rspBo) {
		//定义数据同步BO集合
		List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

		//定义数据同步BO
		SyncEsRunnableBo syncEsRunnableBo = new SyncEsRunnableBo();
		//设置索引名称
		syncEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
		//设置订单ID
		syncEsRunnableBo.setOrderId(reqBo.getOrderId());
		//设置对象ID
		syncEsRunnableBo.setObjId(reqBo.getSaleOrderId());
		//设置操作标识
		syncEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

		//添加到数据同步BO集合
		syncEsRunnableBoList.add(syncEsRunnableBo);

		//批量发货单同步
		for (UocConfirmReceiptShipOrderBO bo : rspBo.getUocConfirmReceiptShipOrderBOList()) {
			//定义发货单数据同步BO
			SyncEsRunnableBo syncBatchShipEsRunnableBo = new SyncEsRunnableBo();
			//设置索引名称
			syncBatchShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
			//设置订单ID
			syncBatchShipEsRunnableBo.setOrderId(bo.getOrderId());
			//设置对象ID
			syncBatchShipEsRunnableBo.setObjId(bo.getShipOrderId());
			//设置操作标识
			syncBatchShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

			//添加到数据同步BO集合
			syncEsRunnableBoList.add(syncBatchShipEsRunnableBo);
		}

		//调用统一线程池
		this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
	}

}
