/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.transactionservice.UocShipOrderArrivaConfirmOrRefuseTransaction;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService"})
public class UocShipOrderArrivaConfirmOrRefuseServiceImpl
implements UocShipOrderArrivaConfirmOrRefuseService {
    private static final Logger log = LoggerFactory.getLogger(UocShipOrderArrivaConfirmOrRefuseServiceImpl.class);
    @Autowired
    private UocShipOrderArrivaConfirmOrRefuseTransaction uocShipOrderArrivaConfirmOrRefuseTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealArriva"})
    public UocShipOrderArrivaConfirmOrRefuseRspBo dealArriva(@RequestBody UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        UocShipOrderArrivaConfirmOrRefuseRspBo rspBo = this.uocShipOrderArrivaConfirmOrRefuseTransaction.dealArriva(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, UocShipOrderArrivaConfirmOrRefuseRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getShipOrderIdList())) {
            for (Long shipOrderId : reqBo.getShipOrderIdList()) {
                SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                shipBo.setOrderId(reqBo.getOrderId());
                shipBo.setObjId(shipOrderId);
                shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(shipBo);
            }
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

