/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocQrySendSapOrderInfoService;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendSapOrderInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendSapOrderInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSendSapOrderBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocQrySendSapOrderInfoService"})
public class UocQrySendSapOrderInfoServiceImpl
implements UocQrySendSapOrderInfoService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"qrySendSalOrderInfo"})
    public UocQrySendSapOrderInfoRspBO qrySendSalOrderInfo(@RequestBody UocQrySendSapOrderInfoReqBO reqBO) {
        UocQrySendSapOrderInfoRspBO rspBO = UocRu.success(UocQrySendSapOrderInfoRspBO.class);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            ArrayList<UocSendSapOrderBO> sendSapOrderBOList = new ArrayList<UocSendSapOrderBO>();
            for (UocSaleOrderItem bo : saleOrderItemList) {
                UocSendSapOrderBO uocSendSapOrderBO = new UocSendSapOrderBO();
                BigDecimal planConversionRate = bo.getPlanConversionRate();
                uocSendSapOrderBO.setSupplierId(bo.getSupplierId());
                java.util.Date createTime = result.getCreateTime();
                DateTimeFormatter YMD = DateTimeFormatter.ofPattern("yyyyMMdd");
                LocalDate localDate = new Date(createTime.getTime()).toLocalDate();
                uocSendSapOrderBO.setBedat(localDate.format(YMD));
                uocSendSapOrderBO.setZddh(result.getSaleOrderNo());
                uocSendSapOrderBO.setZddi(bo.getSaleOrderItemIndex());
                uocSendSapOrderBO.setBanfn(bo.getPlanItemNo());
                uocSendSapOrderBO.setBnfpo(bo.getSaleOrderItemIndex());
                uocSendSapOrderBO.setMenge(bo.getPurchaseCount().multiply(planConversionRate).toString());
                uocSendSapOrderBO.setExtSkuId(bo.getSkuCode());
                uocSendSapOrderBO.setSkuName(bo.getSkuName());
                uocSendSapOrderBO.setPurchaseCount(bo.getPurchaseCount().toString());
                uocSendSapOrderBO.setMaterialCode(bo.getSkuMaterialCode());
                uocSendSapOrderBO.setMaterialName(bo.getSkuMaterialName());
                uocSendSapOrderBO.setCreateName(result.getCreateOperName());
                uocSendSapOrderBO.setUnitName(bo.getUnitName());
                uocSendSapOrderBO.setConversionRatio(planConversionRate.toString());
                BigDecimal salePrice = bo.getSalePrice();
                BigDecimal saleFee = bo.getSaleFee();
                salePrice = salePrice.divide(planConversionRate, 2, RoundingMode.HALF_UP);
                saleFee = saleFee.divide(planConversionRate, 2, RoundingMode.HALF_UP);
                uocSendSapOrderBO.setSalePrice(salePrice.toString());
                BigDecimal tax = bo.getTax().divide(new BigDecimal(100));
                BigDecimal devideNum = BigDecimal.ONE.add(tax);
                BigDecimal untaxSalePrice = salePrice.divide(devideNum, 4, RoundingMode.HALF_UP);
                uocSendSapOrderBO.setNetpr(untaxSalePrice.toString());
                uocSendSapOrderBO.setSaleFee(saleFee.toString());
                BigDecimal totalNoTaxSaleFee = untaxSalePrice.multiply(bo.getPurchaseCount());
                uocSendSapOrderBO.setNoSaleFee(totalNoTaxSaleFee.toString());
                sendSapOrderBOList.add(uocSendSapOrderBO);
            }
            rspBO.setSendSapOrderBOList(sendSapOrderBOList);
        }
        return rspBO;
    }
}

