/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderItemUpdatePlanService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemUpdatePlanReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemUpdatePlanRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderItemUpdatePlanService"})
public class UocSaleOrderItemUpdatePlanServiceImpl
implements UocSaleOrderItemUpdatePlanService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"updateSaleOrderItemPlan"})
    public UocSaleOrderItemUpdatePlanRspBo updateSaleOrderItemPlan(@RequestBody UocSaleOrderItemUpdatePlanReqBo reqBo) {
        this.validateArg(reqBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setSaleOrderItemId(reqBo.getSaleOrderItemId());
        UocSaleOrderDo listSaleOrderItem = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItems = listSaleOrderItem.getSaleOrderItems();
        if (saleOrderItems.isEmpty()) {
            throw new BaseBusinessException("103001", "\u9500\u552e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        UocSaleOrderItem saleOrderItem = saleOrderItems.get(0);
        saleOrderItem.setPlanId(reqBo.getPlanId());
        saleOrderItem.setPlanNo(reqBo.getPlanNo());
        saleOrderItem.setPlanItemId(reqBo.getPlanItemId());
        saleOrderItem.setPlanItemNo(reqBo.getPlanItemNo());
        saleOrderItem.setPlanUnit(reqBo.getPlanUnit());
        saleOrderItem.setSkuMaterialId(reqBo.getSkuMaterialId());
        saleOrderItem.setSkuMaterialCode(reqBo.getSkuMaterialCode());
        saleOrderItem.setSkuMaterialName(reqBo.getSkuMaterialName());
        saleOrderItem.setPlanSource(reqBo.getPlanSource());
        saleOrderItem.setPlanConversionRate(reqBo.getPlanConversionRate());
        this.iUocSaleOrderModel.modifyItemPlanNull(saleOrderItem);
        return UocRu.success(UocSaleOrderItemUpdatePlanRspBo.class);
    }

    private void validateArg(UocSaleOrderItemUpdatePlanReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderItemId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

